package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;


@ApiModel("功能集")
public class ResourcesetDto {

    @ApiModelProperty("功能集id")
    @JsonView(View.class)
    protected Long resourcesetId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty("资源码模块ID")
    @JsonView(View.class)
    protected Long resourceId;

    @ApiModelProperty("功能集Code")
    @JsonView(View.class)
    protected String resourcesetCode;

    @ApiModelProperty("功能集名称")
    @JsonView(View.class)
    protected String resourcesetName;

    @ApiModelProperty("功能集描述")
    @JsonView(View.class)
    protected String resourcesetDesc;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "创建时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    protected Date createTime;


    public Long getResourcesetId() {
        return resourcesetId;
    }

    public void setResourcesetId(Long resourcesetId) {
        this.resourcesetId = resourcesetId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourcesetCode() {
        return resourcesetCode;
    }

    public void setResourcesetCode(String resourcesetCode) {
        this.resourcesetCode = resourcesetCode;
    }

    public String getResourcesetName() {
        return resourcesetName;
    }

    public void setResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
    }

    public String getResourcesetDesc() {
        return resourcesetDesc;
    }

    public void setResourcesetDesc(String resourcesetDesc) {
        this.resourcesetDesc = resourcesetDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourcesetDto that = (ResourcesetDto) o;
        return Objects.equals(resourcesetId, that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetId);
    }
}
