/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.common.date;

import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final ZoneId ZONE_ID = ZoneId.of("+08:00");
    private static final String TIME_ZONE_STR = "Asia/Shanghai";
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("Asia/Shanghai");

    public static Date startOfToday() {
        DateTime dateTime = new DateTime();
        return dateTime.toLocalDate().toDate();
    }

    public static Date endOfToday() {
        DateTime dateTime = new DateTime((Object)new Date());
        return dateTime.plusDays(1).toLocalDate().toDate();
    }

    public static String formatOfToday(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static String format(Date date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return formatter.print(date.getTime());
    }

    public static Date parse(String text, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return DateTime.parse((String)text, (DateTimeFormatter)formatter).toDate();
    }

    public static LocalDate parseLocalDate(String text, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return DateTime.parse((String)text, (DateTimeFormatter)formatter).toLocalDate();
    }

    public static String getBizDate() {
        return DateUtils.formatOfToday("yyyyMMdd");
    }

    public static Boolean isTradeOfToday(Date transDate, Date startOfToday) {
        if (startOfToday.before(transDate)) {
            return true;
        }
        return false;
    }

    public static Boolean isExpiredDate(Date expiredDate) {
        if (expiredDate == null) {
            return false;
        }
        DateTime expiredDateTime = new DateTime((Object)expiredDate);
        return expiredDateTime.isBeforeNow();
    }
}

