/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.exception;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class Params {
    private static final String PARAM_NAME_NULL_ERROR = "Parameter Name must not be null!";
    private static final String PARAM_VALUE_NULL_ERROR = "Parameter Value must not be null!";
    private final Map<String, Object> params;

    private Params(Map<String, Object> params) {
        this.params = params;
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.params);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public Map<String, Object> map() {
        return this.params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> params = new HashMap<String, Object>(4);

        private Builder() {
        }

        public Builder param(String name, Object value) {
            Assert.notNull((Object)name, (String)Params.PARAM_NAME_NULL_ERROR);
            Assert.notNull((Object)value, (String)Params.PARAM_VALUE_NULL_ERROR);
            this.params.put(name, value);
            return this;
        }

        public Params build() {
            return CollectionUtils.isEmpty(this.params) ? new Params(Collections.emptyMap()) : new Params(this.params);
        }
    }
}

