/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.auth.handler;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.handlers.StrictFill;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

@Component
public class CustomizeMetaObjectHandler
implements MetaObjectHandler {
    public static final String CREATED_BY_ID = "createdById";
    public static final String CREATED_DATE = "createdDate";
    public static final String UPDATED_BY_ID = "updatedById";
    public static final String UPDATED_DATE = "updatedDate";
    public static final long DEFAULT_USER_ID = 1L;

    public void insertFill(MetaObject metaObject) {
        Long userId = 1L;
        IAuthorizedUser authorizedUser = this.getUser();
        if (null != authorizedUser) {
            userId = authorizedUser.getId();
        }
        this.strictInsertFill(metaObject, CREATED_BY_ID, Long.class, userId);
        this.strictInsertFill(metaObject, CREATED_DATE, Date.class, new Date());
        this.strictInsertFill(metaObject, UPDATED_BY_ID, Long.class, userId);
        this.strictInsertFill(metaObject, UPDATED_DATE, Date.class, new Date());
    }

    public void updateFill(MetaObject metaObject) {
        Long userId = 1L;
        IAuthorizedUser authorizedUser = this.getUser();
        if (null != authorizedUser) {
            userId = authorizedUser.getId();
        }
        this.updateFill(metaObject, userId);
    }

    protected void updateFill(MetaObject metaObject, Long userId) {
        this.fieldUpdateFill(metaObject, UPDATED_BY_ID, () -> userId, Long.class);
        this.fieldUpdateFill(metaObject, UPDATED_DATE, Date::new, Date.class);
    }

    protected <T, E extends T> MetaObjectHandler fieldUpdateFill(MetaObject metaObject, String fieldName, Supplier<E> fieldVal, Class<T> fieldType) {
        return this.fieldUpdateFill(this.findTableInfo(metaObject), metaObject, Collections.singletonList(StrictFill.of((String)fieldName, fieldVal, fieldType)));
    }

    protected MetaObjectHandler fieldUpdateFill(TableInfo tableInfo, MetaObject metaObject, List<StrictFill<?, ?>> strictFills) {
        return this.fieldFill(false, tableInfo, metaObject, strictFills);
    }

    protected boolean checkField(MetaObject metaObject, String fieldName) {
        return !metaObject.hasSetter(fieldName) || ObjectUtil.isNotNull((Object)metaObject.getValue(fieldName));
    }

    protected MetaObjectHandler fieldFill(boolean insertFill, TableInfo tableInfo, MetaObject metaObject, List<StrictFill<?, ?>> strictFills) {
        if (this.conditionForInsertUpdate(insertFill, tableInfo.isWithInsertFill(), tableInfo.isWithUpdateFill())) {
            strictFills.forEach(i -> {
                String fieldName = i.getFieldName();
                Class fieldType = i.getFieldType();
                tableInfo.getFieldList().stream().filter(j -> j.getProperty().equals(fieldName) && fieldType.equals(j.getPropertyType()) && (insertFill && j.isWithInsertFill() || !insertFill && j.isWithUpdateFill())).findFirst().ifPresent(j -> this.fieldFillStrategy(metaObject, fieldName, i.getFieldVal(), j.isWithUpdateFill()));
            });
        }
        return this;
    }

    protected boolean conditionForInsertUpdate(boolean insertFill, boolean withInsertFill, boolean withUpdateFill) {
        if (insertFill && withInsertFill) {
            return true;
        }
        return !insertFill && withUpdateFill;
    }

    private MetaObjectHandler fieldFillStrategy(MetaObject metaObject, String fieldName, Supplier<?> fieldVal, boolean withUpdateFill) {
        Object obj;
        if ((metaObject.getValue(fieldName) == null || withUpdateFill) && Objects.nonNull(obj = fieldVal.get())) {
            metaObject.setValue(fieldName, obj);
        }
        return this;
    }

    protected IAuthorizedUser getUser() {
        return UserInfoHolder.get();
    }
}

