/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.context;

import com.jayway.jsonpath.ReadContext;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.result.BindingResult;
import com.xforceplus.tenant.data.rule.core.context.AbstractAgreement;
import com.xforceplus.tenant.data.rule.core.context.Agreement;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class ObjectAgreement
extends AbstractAgreement
implements Agreement {
    private ReadContext readContext;
    private String entityCode;
    private boolean failFast;
    private Map<String, BindingResult> bindingResultMap = new HashMap<String, BindingResult>(10);

    private ObjectAgreement() {
    }

    public void addBindingResult(String entityCode, BindingResult bindingResult) {
        this.bindingResultMap.put(entityCode, bindingResult);
    }

    public void addBindingResult(Map<String, BindingResult> bindingResults) {
        this.bindingResultMap.putAll(bindingResults);
    }

    public Map<String, BindingResult> getBindingResultMap() {
        return this.bindingResultMap;
    }

    public ReadContext getReadContext() {
        return this.readContext;
    }

    public void setReadContext(ReadContext readContext) {
        this.readContext = readContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public boolean getFailFast() {
        return this.failFast;
    }

    public String toString() {
        return "ObjectAgreement{" + super.toString() + "readContext=" + this.readContext + ", entityCode='" + this.entityCode + '\'' + ", failFast=" + this.failFast + ", bindingResultMap=" + this.bindingResultMap + '}';
    }

    public static final class Builder {
        private String content;
        private Authorization authorization;
        private String resourceCode;
        private String entityCode;
        private boolean failFast = Boolean.TRUE;

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public Builder resourceCode(String resourceCode) {
            this.resourceCode = resourceCode;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder entityCode(String entityCode) {
            this.entityCode = entityCode;
            return this;
        }

        public ObjectAgreement build() {
            Assert.hasText((String)this.content, (String)"\u6821\u9a8cJSON\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)this.authorization, (String)"\u6388\u6743\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)this.resourceCode, (String)"\u8d44\u6e90\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)this.entityCode, (String)"\u5b9e\u4f53code\u4e0d\u80fd\u4e3a\u7a7a");
            ObjectAgreement agreement = new ObjectAgreement();
            agreement.content = this.content;
            agreement.authorization = this.authorization;
            agreement.resourceCode = this.resourceCode;
            agreement.entityCode = this.entityCode;
            agreement.failFast = this.failFast;
            agreement.next = true;
            return agreement;
        }
    }
}

