/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.context;

import com.jayway.jsonpath.ReadContext;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import com.xforceplus.tenant.data.domain.result.BindingResult;
import com.xforceplus.tenant.data.rule.core.context.AbstractContext;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.Context;
import com.xforceplus.tenant.data.rule.core.searcher.Searcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ObjectContext
extends AbstractContext
implements Context {
    private Args args;
    private ReadContext readContext;
    private String entityCode;
    private boolean failFast;
    private Map<String, BindingResult> bindingResultMap;

    private ObjectContext(Authorization authorization, Boolean authorized, Searcher searcher, String resourceCode, String entityCode, ReadContext readContext, boolean failFast) {
        super(authorization, authorized, searcher, resourceCode);
        this.readContext = readContext;
        this.entityCode = entityCode;
        this.failFast = failFast;
        this.bindingResultMap = new HashMap<String, BindingResult>(10);
    }

    public void reject(String entityCode, String errorCode, Object[] errorArgs, String defaultMessage) {
        BindingResult bindingResult = this.bindingResultMap.computeIfAbsent(this.entityCode, k -> new BindingResult(entityCode));
        String message = (String)StringUtils.defaultIfEmpty((CharSequence)((CharSequence)this.getArgs().get("MESSAGE")), (CharSequence)defaultMessage);
        bindingResult.reject(errorCode, errorArgs, message);
    }

    public void rejectValue(String field, Object fieldValue, Object[] errorArgs, String defaultMessage) {
        this.rejectValue(this.entityCode, field, fieldValue, errorArgs, defaultMessage);
    }

    public void rejectValue(String field, Object fieldValue, String defaultMessage) {
        this.rejectValue(this.entityCode, field, fieldValue, new String[0], defaultMessage);
    }

    public void rejectValue(String entityCode, String field, Object fieldValue, Object[] errorArgs, String defaultMessage) {
        this.rejectValue(entityCode, field, fieldValue, null, errorArgs, defaultMessage);
    }

    public void rejectValue(String entityCode, String field, Object fieldValue, String errorCode, Object[] errorArgs, String defaultMessage) {
        BindingResult bindingResult = this.bindingResultMap.computeIfAbsent(this.entityCode, k -> new BindingResult(entityCode));
        String message = (String)StringUtils.defaultIfEmpty((CharSequence)((CharSequence)this.getArgs().get("MESSAGE")), (CharSequence)defaultMessage);
        bindingResult.rejectValue(field, fieldValue, errorCode, errorArgs, message);
    }

    public Args getArgs() {
        return this.args;
    }

    public void setArgs(Args args) {
        this.args = args;
    }

    public ReadContext getReadContext() {
        return this.readContext;
    }

    public void setReadContext(ReadContext readContext) {
        this.readContext = readContext;
    }

    public boolean getFailFast() {
        return this.failFast;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public Map<String, BindingResult> getBindingResults() {
        return this.bindingResultMap;
    }

    public static class Builder {
        private Authorization authorization = new Authorization();
        private boolean authorized;
        private Searcher searcher;
        private String resourceCode;
        private String entityCode;
        private ReadContext readContext;
        private boolean failFast = Boolean.TRUE;

        public Builder searcher(Searcher searcher) {
            this.searcher = searcher;
            return this;
        }

        public Builder addAuthentication(Authorization authorization) {
            this.authorization.addAll((Collection)authorization.getAuthorizedUsers());
            return this;
        }

        public Builder addAuthorizedUser(AuthorizedUser authorizedUser) {
            this.authorization.add(authorizedUser);
            return this;
        }

        public Builder addAuthorizedUsers(List<AuthorizedUser> authorizedUsers) {
            this.authorization.addAll(authorizedUsers);
            return this;
        }

        public Builder resourceCode(String resourceCode) {
            this.resourceCode = resourceCode;
            return this;
        }

        public Builder entityCode(String entityCode) {
            this.entityCode = entityCode;
            return this;
        }

        public Builder readContext(ReadContext readContext) {
            this.readContext = readContext;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public ObjectContext build() {
            this.authorized = !this.isEmptyAuthentication();
            Assert.hasText((String)this.resourceCode, (String)"\u8d44\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)this.entityCode, (String)"\u5b9e\u4f53code\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)this.searcher, (String)"\u89c4\u5219\u67e5\u8be2\u5668\u672a\u6ce8\u5165");
            Assert.notNull((Object)this.readContext, (String)"JsonPath\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a");
            return new ObjectContext(this.authorization, this.authorized, this.searcher, this.resourceCode, this.entityCode, this.readContext, this.failFast);
        }

        protected boolean isEmptyAuthentication() {
            if (this.authorization == null) {
                return true;
            }
            return this.authorization.isEmpty();
        }
    }
}

