/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.pipeline;

import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import com.xforceplus.tenant.data.domain.rule.Condition;
import com.xforceplus.tenant.data.domain.rule.ConditionRuleResult;
import com.xforceplus.tenant.data.domain.rule.Field;
import com.xforceplus.tenant.data.domain.rule.FieldRule;
import com.xforceplus.tenant.data.domain.rule.FieldRuleResult;
import com.xforceplus.tenant.data.domain.rule.RelationType;
import com.xforceplus.tenant.data.domain.rule.Rule;
import com.xforceplus.tenant.data.domain.rule.RuleResult;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.Context;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.pipeline.Pipeline;
import com.xforceplus.tenant.data.rule.core.searcher.Searcher;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.DefaultArgs;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.pipeline.AbstractObjectPipeline;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.validation.config.Validators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractObjectFieldPipeline
extends AbstractObjectPipeline
implements Pipeline {
    private static final Logger log = LoggerFactory.getLogger(AbstractObjectFieldPipeline.class);

    @Override
    public void doProcess(ObjectContext context) {
        String effect;
        Rule rule;
        List<ConditionRuleResult> conditionRuleResults;
        List<Rule> rules = this.getRules(context);
        if (CollectionUtils.isEmpty(rules)) {
            context.setCause("\u672a\u67e5\u627e\u5230\u8d44\u6e90\u7801\u4e3a:%s\u7684\u6570\u636e\u6821\u9a8c\u89c4\u5219", new String[]{context.getResourceCode()});
            return;
        }
        Boolean status = Boolean.TRUE;
        Iterator<Rule> iterator = rules.iterator();
        while (iterator.hasNext() && (CollectionUtils.isEmpty(conditionRuleResults = this.doProcessConditions(context, rule = iterator.next(), effect = rule.getEffect(), rule.getConditions())) || (status = this.processConditionRuleResults(conditionRuleResults)).booleanValue())) {
        }
        if (!status.booleanValue()) {
            context.refused("\u6821\u9a8c\u7ed3\u679c\u88ab\u62d2\u7edd");
        }
    }

    protected Boolean processConditionRuleResults(List<ConditionRuleResult> conditionRuleResults) {
        Boolean status = Boolean.FALSE;
        conditionRuleResults.sort(Comparator.comparing(RuleResult::getSortNo));
        for (ConditionRuleResult ruleResult : conditionRuleResults) {
            if (RelationType.OR.equals((Object)ruleResult.getRelation()) && ruleResult.getStatus().booleanValue()) {
                status = Boolean.TRUE;
                continue;
            }
            if (RelationType.AND.equals((Object)ruleResult.getRelation()) && ruleResult.getStatus().booleanValue()) {
                status = Boolean.TRUE;
                continue;
            }
            if (!RelationType.AND.equals((Object)ruleResult.getRelation()) || ruleResult.getStatus().booleanValue()) continue;
            status = Boolean.FALSE;
            break;
        }
        return status;
    }

    protected abstract List<ConditionRuleResult> doProcessConditions(ObjectContext var1, Rule var2, String var3, Set<Condition> var4);

    protected List<FieldRuleResult> doProcessFieldRule(ObjectContext context, Rule rule, String effect, Condition condition, List<FieldRule> fieldRules) {
        if (CollectionUtils.isEmpty(fieldRules)) {
            context.setCause("\u672a\u67e5\u627e\u5230\u8d44\u6e90\u7801\u4e3a:%s\u7684\u6570\u636e\u6821\u9a8c\u7684Field\u89c4\u5219", new String[]{context.getResourceCode()});
        }
        fieldRules.sort(Comparator.comparing(Field::getSortNo));
        return this.processConditionFieldRule(context, rule, effect, condition, fieldRules);
    }

    public abstract List<FieldRuleResult> processConditionFieldRule(ObjectContext var1, Rule var2, String var3, Condition var4, List<FieldRule> var5);

    protected ConditionRuleResult processFiledRuleResults(List<FieldRuleResult> ruleResults, Rule rule, Condition condition) {
        Boolean status = this.processFiledRuleResults(ruleResults);
        return ConditionRuleResult.builder().status(status).sortNo(condition.getSortNo()).conditionId(condition.getConditionId()).conditionName(condition.getConditionName()).ruleId(rule.getRuleId()).relation(condition.getNextRelation()).build();
    }

    protected Boolean processFiledRuleResults(List<FieldRuleResult> ruleResults) {
        Boolean status = Boolean.FALSE;
        ruleResults.sort(Comparator.comparing(RuleResult::getSortNo));
        for (FieldRuleResult fieldRuleResult : ruleResults) {
            if (RelationType.OR.equals((Object)fieldRuleResult.getRelation()) && fieldRuleResult.getStatus().booleanValue()) {
                status = Boolean.TRUE;
                continue;
            }
            if (RelationType.AND.equals((Object)fieldRuleResult.getRelation()) && fieldRuleResult.getStatus().booleanValue()) {
                status = Boolean.TRUE;
                continue;
            }
            if (!RelationType.AND.equals((Object)fieldRuleResult.getRelation()) || fieldRuleResult.getStatus().booleanValue()) continue;
            status = Boolean.FALSE;
            break;
        }
        return status;
    }

    protected FieldRuleResult buildFieldRuleResult(R result, Rule rule, Condition condition, FieldRule fieldRule) {
        return FieldRuleResult.builder().status(result.getStatus()).ruleId(rule.getRuleId()).conditionId(condition.getConditionId()).conditionName(condition.getConditionName()).fieldId(fieldRule.getFieldRuleId()).fieldName(fieldRule.getFieldName()).fieldPath(fieldRule.getFieldPath()).range(fieldRule.getRange()).ruleType(fieldRule.getRuleType()).relation(fieldRule.getNextRelation()).sortNo(fieldRule.getSortNo()).build();
    }

    protected Object getValue(ObjectContext context, String filePath) {
        Object value;
        ReadContext readContext = context.getReadContext();
        try {
            value = readContext.read(filePath, new Predicate[0]);
        }
        catch (JsonPathException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6570\u636e\u503c\u51fa\u9519", e);
        }
        return value;
    }

    protected R call(Args args, ObjectContext context, FieldRule fieldRule) {
        Optional<Validator> validator = Validators.getValidation(fieldRule.getRuleType());
        if (!validator.isPresent()) {
            throw new IllegalStateException("\u672a\u67e5\u627e\u5230\u6821\u9a8c\u5668:%s,\u8fd4\u56de\u4e3a\u7a7a");
        }
        context.setArgs(args);
        return validator.get().call((Context)context);
    }

    protected Args setArgs(String fieldPath, ObjectContext context, FieldRule fieldRule) {
        Object value = this.getValue(context, fieldRule.getFieldPath());
        DefaultArgs args = new DefaultArgs();
        args.set("FIELD_PATH", fieldPath);
        args.set("VALUE", value);
        args.set("MAX_VALUE", fieldRule.getMaxValue());
        args.set("MIN_VALUE", fieldRule.getMinValue());
        args.set("MAX_LENGTH", fieldRule.getMaxLength());
        args.set("MIN_LENGTH", fieldRule.getMinLength());
        args.set("PATTERN", fieldRule.getPattern());
        args.set("EXPRESSION", fieldRule.getExpression());
        if (ObjectRuleType.EXPRESSION_AVIATOR.equals(fieldRule.getRuleType())) {
            this.setExprParams(value, args, fieldRule);
        }
        args.set("RANGE_TYPE", fieldRule.getRange());
        args.set("TARGET_VALUE", fieldRule.getTargetValue());
        args.set("DECIMAL", fieldRule.getDecimal());
        args.set("MESSAGE", fieldRule.getMessage());
        args.set("IGNORE_CASE", fieldRule.getIgnoreCase());
        args.set("DATA_DICT", fieldRule.getDataDictionary());
        return args;
    }

    protected void setExprParams(Object value, Args args, FieldRule fieldRule) {
        HashMap<String, Object> exprParams = new HashMap<String, Object>(9);
        exprParams.put("MAX_VALUE", fieldRule.getMaxValue());
        exprParams.put("MIN_VALUE", fieldRule.getMaxValue());
        exprParams.put("MAX_LENGTH", fieldRule.getMaxLength());
        exprParams.put("MIN_LENGTH", fieldRule.getMinValue());
        exprParams.put("PATTERN", fieldRule.getPattern());
        exprParams.put("TARGET_VALUE", fieldRule.getTargetValue());
        exprParams.put("VALUE", value);
        args.set("EXPR_PARAMS", exprParams);
    }

    protected List<Rule> getRules(ObjectContext context) {
        Iterator iterator = context.getAuthorization().getAuthorizedUsers().iterator();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Searcher searcher = context.getSearcher();
        String resourceCode = context.getResourceCode();
        String entityCode = context.getEntityCode();
        while (iterator.hasNext()) {
            AuthorizedUser authorizedUser = (AuthorizedUser)iterator.next();
            List list = searcher.searchRuleByResourceCodeAndEntityCode(authorizedUser, resourceCode, entityCode);
            rules.addAll(list);
        }
        return rules;
    }
}

