/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.pipeline;

import com.xforceplus.tenant.data.domain.rule.Condition;
import com.xforceplus.tenant.data.domain.rule.ConditionRuleResult;
import com.xforceplus.tenant.data.domain.rule.FieldRule;
import com.xforceplus.tenant.data.domain.rule.FieldRuleResult;
import com.xforceplus.tenant.data.domain.rule.Relation;
import com.xforceplus.tenant.data.domain.rule.RelationType;
import com.xforceplus.tenant.data.domain.rule.Rule;
import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.pipeline.Pipeline;
import com.xforceplus.tenant.data.rule.core.rule.PipelineType;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.pipeline.AbstractObjectFieldPipeline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ObjectFailFastConditionFieldPipeline
extends AbstractObjectFieldPipeline
implements Pipeline {
    private static final Logger log = LoggerFactory.getLogger(ObjectFailFastConditionFieldPipeline.class);

    public RuleType getPipelineType() {
        return PipelineType.OBJECT_FAIL_FAST;
    }

    @Override
    protected List<ConditionRuleResult> doProcessConditions(ObjectContext context, Rule rule, String effect, Set<Condition> conditions) {
        ArrayList<ConditionRuleResult> conditionRuleResults = new ArrayList<ConditionRuleResult>();
        if (CollectionUtils.isEmpty(conditions)) {
            context.setCause("\u672a\u67e5\u627e\u5230\u8d44\u6e90\u7801\u4e3a:%s\u7684\u6570\u636e\u6821\u9a8cCondition", new String[]{context.getResourceCode()});
            return Collections.EMPTY_LIST;
        }
        for (Condition condition : conditions) {
            Set fieldRules;
            List<FieldRuleResult> ruleResults = this.doProcessFieldRule(context, rule, effect, condition, new ArrayList<FieldRule>(fieldRules = condition.getFields()));
            if (CollectionUtils.isEmpty(ruleResults)) continue;
            ConditionRuleResult conditionRuleResult = this.processFiledRuleResults(ruleResults, rule, condition);
            if (RelationType.AND.equals((Object)conditionRuleResult.getRelation()) && !conditionRuleResult.getStatus().booleanValue()) {
                conditionRuleResults.add(conditionRuleResult);
                break;
            }
            conditionRuleResults.add(conditionRuleResult);
        }
        return conditionRuleResults;
    }

    @Override
    public List<FieldRuleResult> processConditionFieldRule(ObjectContext context, Rule rule, String effect, Condition condition, List<FieldRule> fieldRules) {
        ArrayList<FieldRuleResult> fieldRuleResults = new ArrayList<FieldRuleResult>();
        for (FieldRule fieldRule : fieldRules) {
            FieldRuleResult fieldRuleResult;
            Args args = this.setArgs(fieldRule.getFieldPath(), context, fieldRule);
            R result = this.call(args, context, fieldRule);
            log.info("result:{},ruleType:{},range:{}", new Object[]{result, fieldRule.getRuleType(), fieldRule.getRange()});
            if (!result.getValid().booleanValue()) continue;
            if (this.processFailFast(result, fieldRule).booleanValue()) {
                fieldRuleResult = this.buildFieldRuleResult(result, rule, condition, fieldRule);
                fieldRuleResults.clear();
                fieldRuleResults.add(fieldRuleResult);
                break;
            }
            fieldRuleResult = this.buildFieldRuleResult(result, rule, condition, fieldRule);
            fieldRuleResults.add(fieldRuleResult);
        }
        return fieldRuleResults;
    }

    protected Boolean processFailFast(R result, FieldRule fieldRule) {
        Relation relation = RelationType.defaultIfNull((Relation)fieldRule.getNextRelation(), (Relation)RelationType.AND);
        if (RelationType.AND.equals((Object)relation) && !result.getStatus().booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

