/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.pipeline.config;

import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.pipeline.Pipeline;
import com.xforceplus.tenant.data.rule.object.pipeline.ObjectUnSupportPipeline;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ObjectPipelineConfig
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ObjectPipelineConfig.class);
    private final Map<RuleType, Pipeline> RULE_TYPE_PIPELINE_MAP = new HashMap<RuleType, Pipeline>();
    private final ApplicationContext applicationContext;
    private static ObjectPipelineConfig instance;
    private final ObjectUnSupportPipeline objectUnSupportPipeline;

    public ObjectPipelineConfig(ApplicationContext applicationContext, ObjectUnSupportPipeline objectUnSupportPipeline) {
        this.applicationContext = applicationContext;
        this.objectUnSupportPipeline = objectUnSupportPipeline;
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
        Map beans = this.applicationContext.getBeansOfType(Pipeline.class);
        if (CollectionUtils.isEmpty((Map)beans)) {
            return;
        }
        for (Map.Entry entry : beans.entrySet()) {
            if (null != ((Pipeline)entry.getValue()).getPipelineType().getType() || ObjectUnSupportPipeline.class.isInstance(entry.getValue())) continue;
            this.RULE_TYPE_PIPELINE_MAP.put(((Pipeline)entry.getValue()).getPipelineType(), (Pipeline)entry.getValue());
        }
    }

    public static Pipeline getPipeline(RuleType ruleType) {
        if (ObjectPipelineConfig.instance.RULE_TYPE_PIPELINE_MAP.containsKey(ruleType)) {
            return ObjectPipelineConfig.instance.RULE_TYPE_PIPELINE_MAP.get(ruleType);
        }
        return ObjectPipelineConfig.instance.objectUnSupportPipeline;
    }
}

