/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.process;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import com.xforceplus.tenant.data.common.TimeUtils;
import com.xforceplus.tenant.data.domain.result.CheckStatus;
import com.xforceplus.tenant.data.rule.core.context.Agreement;
import com.xforceplus.tenant.data.rule.core.process.RuleProcessor;
import com.xforceplus.tenant.data.rule.object.context.ObjectAgreement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectRuleProcessor
implements RuleProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractObjectRuleProcessor.class);

    public void before(ObjectAgreement agreement) {
        log.info("before Object Rule Processor start...");
        try {
            DocumentContext readContext = JsonPath.parse((String)agreement.getContent());
            agreement.setReadContext((ReadContext)readContext);
        }
        catch (Exception e) {
            agreement.setException(e);
        }
    }

    public void process(Agreement agreement) {
        ObjectAgreement objectAgreement = (ObjectAgreement)agreement;
        long startTime = TimeUtils.nowMs();
        this.before(objectAgreement);
        if (!objectAgreement.next().booleanValue()) {
            this.cost(startTime, objectAgreement.next());
            return;
        }
        try {
            log.info("Object Rule Processor  doProcess...");
            this.doProcess(objectAgreement);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            objectAgreement.setException(e, CheckStatus.ERROR);
        }
        this.after(objectAgreement);
        this.cost(startTime, objectAgreement.next());
    }

    public void after(ObjectAgreement objectAgreement) {
        log.info("Object Rule Processor after...");
        log.info("objectAgreementResult status:{}", objectAgreement.getCheckResult().getStatus());
    }

    public abstract void doProcess(ObjectAgreement var1);

    private void cost(Long startTime, boolean next) {
        long cost = TimeUtils.diffMs((long)startTime);
        log.info("cost:{}ms,next:{}", (Object)cost, (Object)next);
    }
}

