/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.process;

import com.xforceplus.tenant.data.domain.result.CheckStatus;
import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Context;
import com.xforceplus.tenant.data.rule.core.pipeline.Pipeline;
import com.xforceplus.tenant.data.rule.core.process.RuleProcessor;
import com.xforceplus.tenant.data.rule.core.rule.PipelineType;
import com.xforceplus.tenant.data.rule.core.searcher.Searcher;
import com.xforceplus.tenant.data.rule.object.context.ObjectAgreement;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.pipeline.ObjectUnSupportPipeline;
import com.xforceplus.tenant.data.rule.object.pipeline.config.ObjectPipelineConfig;
import com.xforceplus.tenant.data.rule.object.process.AbstractObjectRuleProcessor;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultObjectRuleProcessorImpl
extends AbstractObjectRuleProcessor
implements RuleProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultObjectRuleProcessorImpl.class);
    private final Searcher searcher;

    public DefaultObjectRuleProcessorImpl(@Qualifier(value="objectRuleSearcher") Searcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public void doProcess(ObjectAgreement agreement) {
        Pipeline pipeline = this.getPipeline(agreement);
        if (ObjectUnSupportPipeline.class.isInstance(pipeline)) {
            agreement.checkResult(CheckStatus.NOT_SUPPORT, false);
            return;
        }
        ObjectContext context = ObjectContext.builder().addAuthentication(agreement.getAuthorization()).resourceCode(agreement.getResourceCode()).entityCode(agreement.getEntityCode()).searcher(this.searcher).readContext(agreement.getReadContext()).build();
        try {
            pipeline.process((Context)context);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            log.error("Pipeline type:{},json:{},message{}", new Object[]{"OBJECT_ENTITY", agreement.getContent(), e.getMessage(), e});
            agreement.checkResult(CheckStatus.ERROR, Boolean.FALSE, e.getMessage());
            return;
        }
        if (context.getRefused().booleanValue()) {
            agreement.checkResult(CheckStatus.DENIAL, Boolean.FALSE, context.getCause());
            agreement.addBindingResult(context.getBindingResults());
            return;
        }
        this.doPassProcess(agreement, context);
    }

    public Pipeline getPipeline(ObjectAgreement agreement) {
        Pipeline pipeline = agreement.getFailFast() ? ObjectPipelineConfig.getPipeline((RuleType)PipelineType.OBJECT_FAIL_FAST) : ObjectPipelineConfig.getPipeline((RuleType)PipelineType.OBJECT_ENTITY);
        return pipeline;
    }

    protected void doPassProcess(ObjectAgreement agreement, Context context) {
        String message = StringUtils.isNotBlank((String)context.getCause()) ? context.getCause() : "\u6821\u9a8c\u901a\u8fc7";
        agreement.checkResult(CheckStatus.PASS, Boolean.FALSE, message);
    }
}

