/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.type;

import com.xforceplus.tenant.data.domain.rule.Range;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum RangeType implements Range
{
    UN_KNOWN("UN_KNOWN", "\u672a\u77e5"),
    GT_LT(">:<", "\u5927\u4e8e&&\u5c0f\u4e8e"),
    GTE_LTE(">=:=<", "\u5927\u4e8e\u7b49\u4e8e&&\u5c0f\u4e8e\u7b49\u4e8e"),
    GT(">", "\u5927\u4e8e"),
    LT("<", "\u5c0f\u4e8e"),
    GTE(">=", "\u5927\u4e8e\u7b49\u4e8e"),
    LTE("<=", "\u5c0f\u4e8e\u7b49\u4e8e"),
    EQ("=", "\u7b49\u4e8e"),
    NEQ("!=", "\u4e0d\u7b49\u4e8e");

    private String code;
    private String desc;
    private static final Map<String, RangeType> MAP;

    private RangeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static RangeType valuesOf(String code) {
        return MAP.getOrDefault(StringUtils.upperCase((String)code), UN_KNOWN);
    }

    static {
        MAP = new HashMap<String, RangeType>(2);
        for (RangeType rangeType : RangeType.values()) {
            MAP.put(rangeType.name(), rangeType);
        }
    }
}

