/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.config;

import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import com.xforceplus.tenant.data.rule.object.validation.config.Validators;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="objectValidationConfig")
public class ValidationConfig
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ValidationConfig.class);
    private final ApplicationContext applicationContext;

    public ValidationConfig(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        Validators.clear();
    }

    public void afterPropertiesSet() throws Exception {
        Map beans = this.applicationContext.getBeansOfType(Validator.class);
        if (CollectionUtils.isEmpty((Map)beans)) {
            return;
        }
        for (Map.Entry entry : beans.entrySet()) {
            if (!(entry.getValue() instanceof AbstractObjectValidator)) continue;
            Validators.put(((Validator)entry.getValue()).getRuleType(), (Validator)entry.getValue());
        }
    }
}

