/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.date;

import com.xforceplus.tenant.data.common.date.DateUtils;
import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataPatternValidator
extends AbstractObjectValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(DataPatternValidator.class);
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    protected static final String DEFAULT_MESSAGE = "{0}\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6709\u6548\u683c\u5f0f\u5e94\u8be5\u4e3a:{1}";
    protected static final String STRING_MESSAGE = "\u53ea\u80fd\u6821\u9a8c\u6570\u636e\u7c7b\u578b\"\u5b57\u7b26\u4e32\"\uff0c\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u4e3a:{0}";

    @Override
    public R call(String fieldPath, Args args, ObjectContext context) {
        Object objectValue = args.getValue();
        if (objectValue instanceof Date) {
            return R.valid();
        }
        if (!(objectValue instanceof String)) {
            this.message(fieldPath, objectValue, context);
            return R.valid((Boolean)Boolean.FALSE);
        }
        String value = String.valueOf(objectValue);
        String pattern = (String)args.get("PATTERN");
        pattern = (String)StringUtils.defaultIfEmpty((CharSequence)pattern, (CharSequence)DEFAULT_DATE_PATTERN);
        Date date = null;
        try {
            date = DateUtils.parse((String)value, (String)pattern);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        boolean result = date != null;
        this.message(result, fieldPath, objectValue, pattern, context);
        return R.valid((Boolean)result);
    }

    protected void message(boolean result, String fieldPath, Object objectValue, String pattern, ObjectContext context) {
        if (result) {
            return;
        }
        context.rejectValue(fieldPath, objectValue, new Object[]{objectValue, pattern}, DEFAULT_MESSAGE);
    }

    protected void message(String fieldPath, Object objectValue, ObjectContext context) {
        String valueDataType = objectValue == null ? String.class.getSimpleName() : objectValue.getClass().getSimpleName();
        context.rejectValue(fieldPath, objectValue, new Object[]{valueDataType}, STRING_MESSAGE);
    }

    public RuleType getRuleType() {
        return ObjectRuleType.DATE_PATTERN;
    }
}

