/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.date;

import com.xforceplus.tenant.data.common.date.DateUtils;
import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.type.RangeType;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import com.xforceplus.tenant.data.rule.object.validation.range.RangeValidator;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DateRangeValidator
extends AbstractObjectValidator
implements RangeValidator<Date>,
Validator {
    private static final Logger log = LoggerFactory.getLogger(DateRangeValidator.class);
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    @Override
    public R call(String fieldPath, Args args, ObjectContext context) {
        String pattern = (String)args.get("PATTERN");
        pattern = (String)StringUtils.defaultIfEmpty((CharSequence)pattern, (CharSequence)DEFAULT_DATE_PATTERN);
        Date value = this.convertDate(args.getValue(), pattern);
        if (value == null) {
            return R.invalid();
        }
        RangeType rangeType = (RangeType)((Object)args.get("RANGE_TYPE"));
        Date maxValue = this.convertDate(args.get("MAX_VALUE"), pattern);
        Date minValue = this.convertDate(args.get("MIN_VALUE"), pattern);
        Date targetValue = this.convertDate(args.get("TARGET_VALUE"), pattern);
        log.info("value:{},maxValue:{},minValue:{},targetValue:{}", new Object[]{value, maxValue, minValue, targetValue});
        Boolean result = this.rangeType(value, maxValue, minValue, targetValue, rangeType);
        return R.valid((Boolean)result);
    }

    private Date convertDate(Object sourceValue, String pattern) {
        String sourceValueStr;
        if (null == sourceValue) {
            return null;
        }
        if (sourceValue instanceof Date) {
            return (Date)sourceValue;
        }
        if (sourceValue instanceof Long) {
            Long timestamp = (Long)sourceValue;
            return new Date(timestamp);
        }
        if (sourceValue instanceof String && StringUtils.isNotBlank((CharSequence)(sourceValueStr = String.valueOf(sourceValue)))) {
            return DateUtils.parse((String)sourceValueStr, (String)pattern);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b:" + sourceValue.getClass().getSimpleName() + "\u6821\u9a8c");
    }

    public RuleType getRuleType() {
        return ObjectRuleType.DATE_RANGE;
    }

    @Override
    public Boolean rangeEqual(Date value, Date maxValue, Date minValue) {
        if (value == null || maxValue == null || minValue == null) {
            log.warn("\u6821\u9a8c\u53c2\u6570\u4e3a\u7a7a\uff0cvalue:{}\uff0cmaxValue:{}\uff0cminValue:{}", new Object[]{value, maxValue, minValue});
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime(value.getTime());
        DateTime dateMaxValue = new DateTime(maxValue.getTime());
        DateTime dateMinValue = new DateTime(minValue.getTime());
        if (dateTimeValue.isEqual((ReadableInstant)dateMinValue) && dateTimeValue.isEqual((ReadableInstant)dateMaxValue)) {
            return Boolean.TRUE;
        }
        if (dateTimeValue.isEqual((ReadableInstant)dateMinValue) && dateTimeValue.isBefore((ReadableInstant)dateMaxValue)) {
            return Boolean.TRUE;
        }
        if (dateTimeValue.isAfter((ReadableInstant)dateMinValue) && dateTimeValue.equals((Object)dateMaxValue)) {
            return Boolean.TRUE;
        }
        return dateTimeValue.isAfter((ReadableInstant)dateMinValue) && dateTimeValue.isBefore((ReadableInstant)dateMaxValue);
    }

    @Override
    public Boolean gt(Date value, Date targetValue) {
        if (value == null || targetValue == null) {
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime(value.getTime());
        DateTime dateTimeTargetValue = new DateTime(targetValue.getTime());
        return dateTimeValue.isAfter((ReadableInstant)dateTimeTargetValue);
    }

    @Override
    public Boolean lt(Date value, Date targetValue) {
        if (value == null || targetValue == null) {
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime((Object)value);
        DateTime dateTimeTargetValue = new DateTime((Object)targetValue);
        return dateTimeValue.isBefore((ReadableInstant)dateTimeTargetValue);
    }

    @Override
    public Boolean gte(Date value, Date targetValue) {
        if (value == null || targetValue == null) {
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime((Object)value);
        DateTime dateTimeTargetValue = new DateTime((Object)targetValue);
        if (dateTimeValue.isEqual((ReadableInstant)dateTimeTargetValue)) {
            return Boolean.TRUE;
        }
        return dateTimeValue.isAfter((ReadableInstant)dateTimeTargetValue);
    }

    @Override
    public Boolean lte(Date value, Date targetValue) {
        if (value == null || targetValue == null) {
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime((Object)value);
        DateTime dateTimeTargetValue = new DateTime((Object)targetValue);
        if (dateTimeValue.isEqual((ReadableInstant)dateTimeTargetValue)) {
            return Boolean.TRUE;
        }
        return dateTimeValue.isBefore((ReadableInstant)dateTimeTargetValue);
    }

    @Override
    public Boolean eq(Date value, Date targetValue) {
        if (value == null || targetValue == null) {
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime(value.getTime());
        DateTime dateTimeTargetValue = new DateTime(targetValue.getTime());
        return dateTimeValue.isEqual((ReadableInstant)dateTimeTargetValue);
    }

    @Override
    public Boolean neq(Date value, Date targetValue) {
        return this.eq(value, targetValue) == false;
    }

    @Override
    public Boolean range(Date value, Date maxValue, Date minValue) {
        if (value == null || maxValue == null || minValue == null) {
            return Boolean.FALSE;
        }
        DateTime dateTimeValue = new DateTime(value.getTime());
        DateTime dateMaxValue = new DateTime(maxValue.getTime());
        DateTime dateMinValue = new DateTime(minValue.getTime());
        return dateTimeValue.isBefore((ReadableInstant)dateMaxValue) && dateTimeValue.isAfter((ReadableInstant)dateMinValue);
    }
}

