/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.expression;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.ArgParams;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ExpressionAviatorValidator
extends AbstractObjectValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(ExpressionAviatorValidator.class);
    private static final boolean AVIATOR_CACHED = Boolean.TRUE;

    @Override
    public R call(String fieldPath, Args args, ObjectContext context) {
        String expression = this.convert(args.get("EXPRESSION"));
        Assert.hasText((String)expression, (String)"Aviator\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Expression compileExpression = this.getExpression(expression, args, context);
        Map<String, Object> params = this.getParams(args);
        log.debug("expression:{},params:{}", (Object)expression, params);
        Object object = null;
        try {
            object = compileExpression.execute(params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u6267\u884c\u8868\u8fbe\u5931\u8d25");
        }
        if (Boolean.class.isInstance(object)) {
            return R.valid((Boolean)((Boolean)object));
        }
        String message = "\u8868\u8fbe\u5f0f:" + expression + " \u6267\u884c\u7684\u7ed3\u679c" + object + "\u4e0d\u6b63\u786e,\u53c2\u6570:{}" + params;
        log.debug("express:{}", (Object)message);
        throw new IllegalArgumentException(message);
    }

    public Map<String, Object> getParams(Args args) {
        Object obj = args.get("EXPR_PARAMS");
        if (null == obj) {
            return Collections.EMPTY_MAP;
        }
        Assert.isInstanceOf(ArgParams.class, (Object)obj, (String)"\u8868\u8fbe\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e,\u4f20\u5165\u8868\u8fbe\u5f0f\u53c2\u6570\u4e3a");
        return ((ArgParams)obj).getParams();
    }

    protected Expression getExpression(String expression, Args args, ObjectContext context) {
        Expression compileExpression;
        try {
            compileExpression = AviatorEvaluator.compile((String)expression, (boolean)AVIATOR_CACHED);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Aviator\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u7f16\u8bd1\u5931\u8d25");
        }
        return compileExpression;
    }

    protected String convert(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Character) {
            return String.valueOf(obj);
        }
        if (null == obj) {
            return null;
        }
        throw new IllegalArgumentException("\u8868\u8fbe\u5f0f\u7c7b\u578b\u4ec5\u652f\u6301String,char Character,\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b\uff1a" + obj.getClass().getSimpleName() + "\u7684\u6570\u636e");
    }

    public RuleType getRuleType() {
        return ObjectRuleType.EXPRESSION_AVIATOR;
    }
}

