/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.number;

import com.xforceplus.tenant.data.common.number.NumberUtils;
import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DecimalValidator
extends AbstractObjectValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(DecimalValidator.class);
    public static final String DEFAULT_DECIMAL = "0,2";
    public static final String DEFAULT_MESSAGE = "";

    @Override
    public R call(String fieldPath, Args args, ObjectContext context) {
        String value = null;
        if (args.getValue() instanceof String) {
            value = (String)args.getValue();
        } else {
            Object objectValue = args.getValue();
            value = String.valueOf(objectValue);
        }
        String decimal = (String)args.get("DECIMAL");
        decimal = (String)StringUtils.defaultIfEmpty((CharSequence)decimal, (CharSequence)DEFAULT_DECIMAL);
        boolean result = this.call(value, decimal);
        return R.valid((Boolean)result);
    }

    private boolean call(String value, String decimal) {
        return NumberUtils.isDecimal((String)value, (String)decimal);
    }

    public RuleType getRuleType() {
        return ObjectRuleType.NUMBER_DECIMAL;
    }
}

