/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.number;

import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.convert.ConvertUtils;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.type.RangeType;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import com.xforceplus.tenant.data.rule.object.validation.range.RangeValidator;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NumberValidator
extends AbstractObjectValidator
implements RangeValidator<BigDecimal>,
Validator {
    private static final Logger log = LoggerFactory.getLogger(NumberValidator.class);

    @Override
    public R call(String fieldPath, Args args, ObjectContext context) {
        Object objectValue = args.get("VALUE");
        BigDecimal value = ConvertUtils.convert(objectValue);
        BigDecimal targetValue = ConvertUtils.convert(args.get("TARGET_VALUE"));
        BigDecimal maxValue = ConvertUtils.convert(args.get("MAX_VALUE"));
        BigDecimal minValue = ConvertUtils.convert(args.get("MIN_VALUE"));
        RangeType rangeType = (RangeType)((Object)args.get("RANGE_TYPE"));
        Boolean result = this.rangeType(value, maxValue, minValue, targetValue, rangeType);
        return R.valid((Boolean)result);
    }

    @Override
    public Boolean rangeEqual(BigDecimal value, BigDecimal maxValue, BigDecimal minValue) {
        log.info(">:{}", (Object)value.compareTo(maxValue));
        log.info("<:{}", (Object)value.compareTo(minValue));
        return value != null && maxValue != null && minValue != null && value.compareTo(maxValue) != 1 && value.compareTo(minValue) != -1;
    }

    @Override
    public Boolean range(BigDecimal value, BigDecimal maxValue, BigDecimal minValue) {
        return value != null && maxValue != null && minValue != null && value.compareTo(maxValue) == -1 && value.compareTo(minValue) == 1;
    }

    @Override
    public Boolean gt(BigDecimal value, BigDecimal targetValue) {
        return value != null && value.compareTo(targetValue) == 1;
    }

    @Override
    public Boolean lt(BigDecimal value, BigDecimal targetValue) {
        return value != null && value.compareTo(targetValue) == -1;
    }

    @Override
    public Boolean gte(BigDecimal value, BigDecimal targetValue) {
        return value != null && value.compareTo(targetValue) != -1;
    }

    @Override
    public Boolean lte(BigDecimal value, BigDecimal targetValue) {
        return value != null && value.compareTo(targetValue) != 1;
    }

    @Override
    public Boolean eq(BigDecimal value, BigDecimal targetValue) {
        return value != null && value.equals(targetValue);
    }

    @Override
    public Boolean neq(BigDecimal value, BigDecimal targetValue) {
        return this.eq(value, targetValue) == false;
    }

    public RuleType getRuleType() {
        return ObjectRuleType.NUMBER_RANGE;
    }
}

