/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.range;

import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.type.RangeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RangeValidator<T>
extends Validator {
    public static final Logger log = LoggerFactory.getLogger(RangeValidator.class);

    default public Boolean rangeType(T value, T maxValue, T minValue, T targetValue, RangeType rangeType) {
        Boolean result = Boolean.FALSE;
        switch (rangeType) {
            case GTE_LTE: {
                result = this.rangeEqual(value, maxValue, minValue);
                break;
            }
            case GT_LT: {
                result = this.range(value, maxValue, minValue);
                break;
            }
            case GTE: {
                result = this.gte(value, targetValue);
                break;
            }
            case GT: {
                result = this.gt(value, targetValue);
                break;
            }
            case LTE: {
                result = this.lte(value, targetValue);
                break;
            }
            case LT: {
                result = this.lt(value, targetValue);
                break;
            }
            case EQ: {
                result = this.eq(value, targetValue);
                break;
            }
            case NEQ: {
                result = this.neq(value, targetValue);
                break;
            }
            default: {
                log.warn("\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684RangeType");
            }
        }
        return result;
    }

    public Boolean rangeEqual(T var1, T var2, T var3);

    public Boolean range(T var1, T var2, T var3);

    public Boolean gt(T var1, T var2);

    public Boolean lt(T var1, T var2);

    public Boolean gte(T var1, T var2);

    public Boolean lte(T var1, T var2);

    public Boolean eq(T var1, T var2);

    public Boolean neq(T var1, T var2);
}

