/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.str;

import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.validation.AbstractObjectValidator;
import org.springframework.util.Assert;

public abstract class AbstractLengthValidator
extends AbstractObjectValidator
implements Validator {
    public Boolean rangeLengthEqual(Integer length, Integer maxLength, Integer minLength) {
        this.checkArgs(length, minLength, maxLength);
        return length <= maxLength && length >= minLength;
    }

    public Boolean rangeLength(Integer length, Integer maxLength, Integer minLength) {
        this.checkArgs(length, minLength, maxLength);
        return length < maxLength && length > minLength;
    }

    public Boolean gte(Integer length, Integer targetValue) {
        this.checkArgs(length, targetValue);
        return length >= targetValue;
    }

    public Boolean gt(Integer length, Integer targetValue) {
        this.checkArgs(length, targetValue);
        return length >= targetValue;
    }

    public Boolean lte(Integer length, Integer targetValue) {
        this.checkArgs(length, targetValue);
        return length <= targetValue;
    }

    public Boolean lt(Integer length, Integer targetValue) {
        this.checkArgs(length, targetValue);
        return length < targetValue;
    }

    public Boolean eq(Integer length, Integer targetValue) {
        this.checkArgs(length, targetValue);
        return length.equals(targetValue);
    }

    public Boolean neq(Integer length, Integer targetValue) {
        this.checkArgs(length, targetValue);
        return this.eq(length, targetValue) == false;
    }

    protected void checkArgs(Integer length, Integer targetValue) {
        Assert.notNull((Object)length, (String)"\u503c\u7684\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)targetValue, (String)"\u7528\u4e8e\u6bd4\u8f83\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected void checkArgs(Integer length, Integer minLength, Integer maxLength) {
        Assert.notNull((Object)length, (String)"\u503c\u7684\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)minLength, (String)"\u7528\u4e8e\u6bd4\u8f83\u5b57\u7b26\u6700\u5c0f\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)maxLength, (String)"\u7528\u4e8e\u6bd4\u8f83\u5b57\u7b26\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

