/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.rule.object.validation.str;

import com.xforceplus.tenant.data.domain.rule.RuleType;
import com.xforceplus.tenant.data.rule.core.context.Args;
import com.xforceplus.tenant.data.rule.core.context.R;
import com.xforceplus.tenant.data.rule.core.validation.Validator;
import com.xforceplus.tenant.data.rule.object.context.ObjectContext;
import com.xforceplus.tenant.data.rule.object.convert.ConvertUtils;
import com.xforceplus.tenant.data.rule.object.type.ObjectRuleType;
import com.xforceplus.tenant.data.rule.object.type.RangeType;
import com.xforceplus.tenant.data.rule.object.validation.str.AbstractLengthValidator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StringLengthValidator
extends AbstractLengthValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(StringLengthValidator.class);
    private static final String MESSAGE_EMPTY_ERROR = "%s\u5b57\u7b26\u4e0d\u80fd\u4e3a\u7a7a";

    public RuleType getRuleType() {
        return ObjectRuleType.STRING_LENGTH;
    }

    @Override
    public R call(String fieldPath, Args args, ObjectContext context) {
        String value = (String)args.getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            context.rejectValue(context.getEntityCode(), fieldPath, value, null, MESSAGE_EMPTY_ERROR);
            return R.invalid();
        }
        RangeType rangeType = (RangeType)((Object)args.get("RANGE_TYPE"));
        Integer valueLength = StringUtils.length((CharSequence)value);
        BigDecimal maxLength = ConvertUtils.convert(args.get("MAX_LENGTH"));
        BigDecimal minLength = ConvertUtils.convert(args.get("MIN_LENGTH"));
        BigDecimal targetLength = ConvertUtils.convert(args.get("TARGET_VALUE"));
        boolean result = this.call(rangeType, valueLength, targetLength, minLength, maxLength);
        this.message(result, fieldPath, value, rangeType, targetLength, minLength, maxLength, context);
        return R.valid((Boolean)result);
    }

    protected void message(boolean result, String fieldPath, String value, RangeType rangeType, BigDecimal targetLength, BigDecimal min, BigDecimal max, ObjectContext context) {
        Object[] errorArgs;
        if (result) {
            return;
        }
        Integer targetValue = this.convertInteger(targetLength);
        Integer maxLength = this.convertInteger(max);
        Integer minLength = this.convertInteger(min);
        Optional<RangeTypeMessage> messageOptional = RangeTypeMessage.getRangeTypeMessage(rangeType);
        if (!messageOptional.isPresent()) {
            messageOptional = Optional.of(RangeTypeMessage.DEFAULT_MESSAGE);
        }
        RangeTypeMessage rangeTypeMessage = messageOptional.get();
        switch (rangeType) {
            case GTE_LTE: 
            case GT_LT: {
                errorArgs = new Object[]{value, minLength, maxLength};
                break;
            }
            case GTE: 
            case GT: 
            case LTE: 
            case LT: 
            case EQ: 
            case NEQ: {
                errorArgs = new Object[]{value, targetValue};
                break;
            }
            default: {
                errorArgs = new Object[]{value};
            }
        }
        context.rejectValue(fieldPath, value, errorArgs, rangeTypeMessage.getMessage());
    }

    public boolean call(RangeType rangeType, Integer length, BigDecimal targetLength, BigDecimal min, BigDecimal max) {
        boolean result = Boolean.FALSE;
        Integer targetValue = this.convertInteger(targetLength);
        Integer maxLength = this.convertInteger(max);
        Integer minLength = this.convertInteger(min);
        switch (rangeType) {
            case GTE_LTE: {
                result = super.rangeLengthEqual(length, maxLength, minLength);
                break;
            }
            case GT_LT: {
                result = super.rangeLength(length, maxLength, minLength);
                break;
            }
            case GTE: {
                result = super.gte(length, targetValue);
                break;
            }
            case GT: {
                result = super.gt(length, targetValue);
                break;
            }
            case LTE: {
                result = super.lte(length, targetValue);
                break;
            }
            case LT: {
                result = super.lt(length, targetValue);
                break;
            }
            case EQ: {
                result = super.eq(length, targetValue);
                break;
            }
            case NEQ: {
                result = super.neq(length, targetValue);
                break;
            }
            default: {
                log.warn("\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684RangeType");
            }
        }
        return result;
    }

    private Integer convertInteger(BigDecimal length) {
        if (null == length) {
            return null;
        }
        return length.intValue();
    }

    public static enum RangeTypeMessage {
        GTE_LTE_MESSAGE(RangeType.GTE_LTE, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5305\u542b\u5728{1}\u548c{2}\u4e4b\u95f4"),
        GT_LT_MESSAGE(RangeType.GT_LT, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5728{1}\u548c{2}\u4e4b\u95f4"),
        GTE_MESSAGE(RangeType.GTE, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e{1}"),
        GT_MESSAGE(RangeType.GT, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e{1}"),
        LT_MESSAGE(RangeType.LT, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e{1}"),
        LTE_MESSAGE(RangeType.LTE, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e{1}"),
        NEQ_MESSAGE(RangeType.NEQ, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u4e0d\u7b49\u4e8e{1}"),
        EQ_MESSAGE(RangeType.EQ, "{0}\u7684\u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u7b49\u4e8e{1}"),
        DEFAULT_MESSAGE(null, "{0}\u6ca1\u6709\u5339\u914d\u5230\u5408\u9002\u7684RangeType");

        private final RangeType rangeType;
        private final String message;
        private static final Map<RangeType, RangeTypeMessage> MAP;

        private RangeTypeMessage(RangeType rangeType, String message) {
            this.rangeType = rangeType;
            this.message = message;
        }

        public RangeType getRangeType() {
            return this.rangeType;
        }

        public String getMessage() {
            return this.message;
        }

        public static Optional<RangeTypeMessage> getRangeTypeMessage(RangeType rangeType) {
            return Optional.ofNullable(MAP.get((Object)rangeType));
        }

        static {
            MAP = new HashMap<RangeType, RangeTypeMessage>(9);
            for (RangeTypeMessage rangeTypeMessage : RangeTypeMessage.values()) {
                MAP.put(rangeTypeMessage.getRangeType(), rangeTypeMessage);
            }
        }
    }
}

