package com.xforceplus.tenant.sql.parser.jsqlparser.processor;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.From;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.JSqlParserFromAbility;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.JSqlParserInsertItemAbility;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.JSqlParserInsertValueAbility;
import com.xforceplus.tenant.sql.parser.processor.InsertSqlProcessor;
import com.xforceplus.tenant.sql.parser.processor.ability.FieldFromAbility;
import com.xforceplus.tenant.sql.parser.processor.ability.FromAbility;
import com.xforceplus.tenant.sql.parser.processor.ability.InsertItemAbility;
import com.xforceplus.tenant.sql.parser.processor.ability.InsertValueAbility;
import net.sf.jsqlparser.statement.Statement;

import java.util.AbstractMap;
import java.util.Arrays;

/**
 * insert
 *
 * @author dongbin
 * @version 0.1 2019/10/25 18:55
 * @since 1.8
 */
public class JInsertSqlProcessor extends JSqlProcessor implements InsertSqlProcessor {
    public JInsertSqlProcessor(Statement statement) {
        super(statement);
    }

    @Override
    public FromAbility buildFromAbility() {
        return new JSqlParserFromAbility(getStatement());
    }

    @Override
    public InsertValueAbility buildInsertValueAbility() {
        return new JSqlParserInsertValueAbility(getStatement());
    }

    @Override
    public InsertItemAbility buildInsertItemAbility() {
        return new JSqlParserInsertItemAbility(getStatement());
    }

    @Override
    public FieldFromAbility buildFieldFromAbility() {
        return item -> {
            FromAbility fromAbility = buildFromAbility();
            From from = fromAbility.list().stream().findFirst().get();


            return Arrays.asList(new AbstractMap.SimpleEntry<>((Field) item, from));
        };
    }

}
