package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.InsertItemAbility;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * insert column 子句.
 *
 * @author dongbin
 * @version 0.1 2019/10/30 15:58
 * @since 1.8
 */
public class JSqlParserInsertItemAbility extends AbstractJSqlParserHandler implements InsertItemAbility {

    public JSqlParserInsertItemAbility(Statement statement) {
        super(statement, Insert.class);
    }

    @Override
    public List<Field> list() throws ProcessorException {
        Insert insert = getInsert();
        List<Column> columns = insert.getColumns();
        if (columns != null && !columns.isEmpty()) {
            return columns.stream().map(c -> ConversionHelper.convert(c)).collect(Collectors.toList());
        } else {
            return Collections.EMPTY_LIST;
        }
    }

}
