/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.From;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.FromAbility;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;

public class JSqlParserFromAbility
extends AbstractJSqlParserHandler
implements FromAbility {
    public JSqlParserFromAbility(PlainSelect plainSelect) {
        super(plainSelect);
    }

    public JSqlParserFromAbility(Statement statement) {
        super(statement);
    }

    @Override
    public List<From> list() throws ProcessorException {
        final ArrayList<From> items = new ArrayList<From>();
        if (this.isSubSelect()) {
            this.getSubSelect().accept((SelectVisitor)new SelectVisitImpl(items));
        } else {
            this.getStatement().accept((StatementVisitor)new StatementVisitorAdapter(){

                public void visit(Select select) {
                    SelectBody body = select.getSelectBody();
                    if (body != null) {
                        body.accept((SelectVisitor)new SelectVisitImpl(items));
                    }
                }

                public void visit(Delete delete) {
                    Table table = delete.getTable();
                    items.add(ConversionHelper.convert(table));
                }

                public void visit(Update update) {
                    Table table = update.getTable();
                    items.add(ConversionHelper.convert(table));
                }

                public void visit(Insert insert) {
                    Table table = insert.getTable();
                    items.add(ConversionHelper.convert(table));
                }
            });
        }
        return items;
    }

    private static class SelectVisitImpl
    extends SelectVisitorAdapter {
        private List<From> items;
        private FromItemVisitor visitor = new FromItemVisitorAdapter(){

            public void visit(Table table) {
                From from = new From(table.getName(), ConversionHelper.convert(table.getAlias()));
                items.add(from);
            }

            public void visit(SubSelect subSelect) {
                From from = new From(subSelect.getSelectBody().toString(), subSelect.getAlias() != null ? ConversionHelper.convert(subSelect.getAlias()) : null, true);
                items.add(from);
            }
        };

        public SelectVisitImpl(List<From> items) {
            this.items = items;
        }

        public void visit(PlainSelect plainSelect) {
            List joins;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem != null) {
                fromItem.accept(this.visitor);
            }
            if ((joins = plainSelect.getJoins()) != null) {
                for (Join join : joins) {
                    join.getRightItem().accept(this.visitor);
                }
            }
        }
    }
}

