package com.xforceplus.tenant.sql.parser.jsqlparser;

import com.xforceplus.tenant.sql.parser.Sql;
import com.xforceplus.tenant.sql.parser.SqlParser;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;

/**
 * 基于 jsqlparser 的实现.
 *
 * https://github.com/JSQLParser/JSqlParser
 *
 * @version 0.1 2019/10/24 10:50
 * @author dongbin
 * @since 1.8
 */
public class JSqlParser implements SqlParser {

    private static final SqlParser SQL_PARSER = new JSqlParser();

    private JSqlParser() {

    }

    public static SqlParser getInstance() {
        return SQL_PARSER;
    }

    @Override
    public Sql parser(String sql) throws ProcessorException {
        Statement statement;
        try {
            statement = CCJSqlParserUtil.parse(sql);
        } catch (JSQLParserException e) {
            throw new ProcessorException(e.getMessage(), e);
        }

        return new JSql(statement);
    }

    @Override
    public boolean isSupport(String sql) {
        try {
            CCJSqlParserUtil.parse(sql);
        } catch (JSQLParserException e) {
            return false;
        }

        return true;
    }
}
