package com.xforceplus.tenant.sql.parser.jsqlparser.processor;

import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.*;
import com.xforceplus.tenant.sql.parser.processor.SelectSqlProcessor;
import com.xforceplus.tenant.sql.parser.processor.ability.*;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;

/**
 * select
 * @version 0.1 2019/10/25 18:50
 * @author dongbin
 * @since 1.8
 */
public class JSelectSqlProcessor extends JSqlProcessor implements SelectSqlProcessor {

    public JSelectSqlProcessor(Statement statement) {
        super(statement);
    }

    @Override
    public ConditionAbility buildConditionAbility() {
        return new JSqlParserConditionAbility(getStatement());
    }

    @Override
    public FromAbility buildFromAbility() {
        return new JSqlParserFromAbility(getStatement());
    }

    @Override
    public SelectItemAbility buildSelectItemAbility() {
        return new JSqlParserSelectItemAbility(getStatement());
    }

    @Override
    public SubSqlAbility buildSubSqlAbility() {
        return new JSqlParserSubSqlAbility((Select) getStatement());
    }

    @Override
    public FieldFromAbility buildFieldFromAbility() {
        return new JSqlParserSelectFieldFromAbility(getStatement());
    }


}
