/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define;

import com.xforceplus.tenant.sql.parser.define.Alias;
import com.xforceplus.tenant.sql.parser.define.Aliasable;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import java.util.Objects;

public class Field
extends Aliasable
implements Item {
    private static final Field ALL_ITEM = new Field("*");
    private String ref;
    private String name;

    public static Field getAllField() {
        return ALL_ITEM;
    }

    public Field(String name) {
        this(null, name, null);
    }

    public Field(String ref, String name) {
        this(ref, name, null);
    }

    public Field(String name, Alias alias) {
        this(null, name, alias);
    }

    public Field(String ref, String name, Alias alias) {
        super(alias);
        this.ref = ref;
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException("Invalid field name!");
        }
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isAllColumns() {
        return "*".equals(this.name);
    }

    public String getRef() {
        return this.ref;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAll() {
        return "*".equals(this.name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.getRef(), field.getRef()) && Objects.equals(this.getName(), field.getName()) && Objects.equals(this.getAlias(), field.getAlias());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getRef(), this.getName(), this.getAlias());
    }

    @Override
    public String toString() {
        return "Field{ref='" + this.ref + '\'' + ", name='" + this.name + '\'' + ", alias='" + (this.hasAlias() ? this.getAlias() : "null") + '\'' + '}';
    }

    @Override
    public String toSqlString() {
        StringBuilder buff = new StringBuilder();
        if (this.ref != null && !this.ref.isEmpty()) {
            buff.append(this.ref).append(".");
        }
        buff.append(this.name);
        if (this.hasAlias()) {
            buff.append(this.getAlias().toSqlString());
        }
        return buff.toString();
    }
}

