/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.Condition;
import com.xforceplus.tenant.sql.parser.define.ConditionOperator;
import com.xforceplus.tenant.sql.parser.define.Conditional;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.relationship.Relationship;
import com.xforceplus.tenant.sql.parser.define.values.NullValue;
import com.xforceplus.tenant.sql.parser.define.values.StringValue;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.ConditionAbility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;

public class JSqlParserConditionAbility
extends AbstractJSqlParserHandler
implements ConditionAbility {
    private static final Expression ROOT_FLAG = new RootExpression();
    private Expression where;

    public JSqlParserConditionAbility(PlainSelect plainSelect) {
        super(plainSelect);
        this.where = plainSelect.getWhere();
    }

    public JSqlParserConditionAbility(Statement statement) {
        super(statement);
        this.getStatement().accept((StatementVisitor)new StatementVisitorAdapter(){

            public void visit(Select select) {
                SelectBody body = select.getSelectBody();
                if (body != null) {
                    body.accept((SelectVisitor)new SelectVisitorAdapter(){

                        public void visit(PlainSelect plainSelect) {
                            JSqlParserConditionAbility.this.where = plainSelect.getWhere();
                        }
                    });
                }
            }

            public void visit(Delete delete) {
                JSqlParserConditionAbility.this.where = delete.getWhere();
            }

            public void visit(Update update) {
                JSqlParserConditionAbility.this.where = update.getWhere();
            }
        });
    }

    @Override
    public void add(Condition condition, Conditional conditional, boolean isolation) throws ProcessorException {
        this.addAll(condition, conditional, isolation);
    }

    @Override
    public void add(Relationship conditions, Conditional conditional, boolean isolation) throws ProcessorException {
        this.addAll(conditions, conditional, isolation);
    }

    private void addAll(Item conditions, Conditional conditional, boolean isolation) throws ProcessorException {
        Expression newCondition = this.buildExpression(conditions);
        switch (conditional) {
            case AND: {
                this.doAdd(true, this.where, newCondition, isolation);
                break;
            }
            case OR: {
                this.doAdd(false, this.where, newCondition, isolation);
                break;
            }
            default: {
                throw new ProcessorException("Can not add condition!");
            }
        }
    }

    @Override
    public void remove(Condition condition) throws ProcessorException {
        if (this.where != null) {
            Expression targetExpression = this.buildExpression(condition);
            if (ComparisonOperator.class.isInstance(this.where)) {
                if (JSqlParserConditionAbility.equalsExpr(this.where, targetExpression)) {
                    this.setWhere(null);
                }
            } else {
                HashMap<Expression, FatherInfo> familyBook = new HashMap<Expression, FatherInfo>();
                familyBook.put(ROOT_FLAG, new FatherInfo(true, this.where));
                RemoveExprVisit visitor = new RemoveExprVisit(targetExpression, familyBook);
                this.where.accept((ExpressionVisitor)visitor);
                this.setWhere(((FatherInfo)familyBook.get(ROOT_FLAG)).getExpr());
            }
        }
    }

    @Override
    public List<Condition> list() throws ProcessorException {
        if (this.where == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList<Condition> conditions = new ArrayList<Condition>();
        this.where.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(Between expr) {
                Column c = (Column)expr.getLeftExpression();
                List<Item> values = Arrays.asList(ConversionHelper.convertSmart(expr.getBetweenExpressionStart()), ConversionHelper.convertSmart(expr.getBetweenExpressionEnd()));
                conditions.add(JSqlParserConditionAbility.this.buildCondition((Expression)c, values, ConditionOperator.BETWEEN));
            }

            public void visit(InExpression expr) {
                Column c = (Column)expr.getLeftExpression();
                if (SubSelect.class.isInstance(expr.getRightItemsList())) {
                    conditions.add(JSqlParserConditionAbility.this.buildCondition((Expression)c, Arrays.asList(new StringValue(((SubSelect)expr.getRightItemsList()).getSelectBody().toString())), expr.isNot() ? ConditionOperator.NOT_IN : ConditionOperator.IN));
                } else {
                    ExpressionList expressionList = (ExpressionList)expr.getRightItemsList();
                    List expressions = expressionList.getExpressions();
                    List values = expressions.stream().map(e -> ConversionHelper.convertSmart(e)).collect(Collectors.toList());
                    conditions.add(JSqlParserConditionAbility.this.buildCondition((Expression)c, values, expr.isNot() ? ConditionOperator.NOT_IN : ConditionOperator.IN));
                }
            }

            public void visit(IsNullExpression expr) {
                conditions.add(JSqlParserConditionAbility.this.buildCondition(expr.getLeftExpression(), Arrays.asList(NullValue.getInstance()), expr.isNot() ? ConditionOperator.IS_NOT : ConditionOperator.IS));
            }

            public void visit(LikeExpression expr) {
                conditions.add(JSqlParserConditionAbility.this.buildCondition(expr.getLeftExpression(), Arrays.asList(ConversionHelper.convertSmart(expr.getRightExpression())), ConditionOperator.LIKE));
            }

            public void visit(EqualsTo expr) {
                this.doAddComparisionCondition((ComparisonOperator)expr, ConditionOperator.EQUALS);
            }

            public void visit(GreaterThan expr) {
                this.doAddComparisionCondition((ComparisonOperator)expr, ConditionOperator.GREATER_THAN);
            }

            public void visit(GreaterThanEquals expr) {
                this.doAddComparisionCondition((ComparisonOperator)expr, ConditionOperator.GREATER_THAN_EQUALS);
            }

            public void visit(MinorThan expr) {
                this.doAddComparisionCondition((ComparisonOperator)expr, ConditionOperator.MINOR_THAN);
            }

            public void visit(MinorThanEquals expr) {
                this.doAddComparisionCondition((ComparisonOperator)expr, ConditionOperator.MINOR_THAN_EQUALS);
            }

            public void visit(NotEqualsTo expr) {
                this.doAddComparisionCondition((ComparisonOperator)expr, ConditionOperator.NOT_EQUALS);
            }

            private void doAddComparisionCondition(ComparisonOperator expr, ConditionOperator operator) {
                conditions.add(JSqlParserConditionAbility.this.buildCondition(expr.getLeftExpression(), Arrays.asList(ConversionHelper.convertSmart(expr.getRightExpression())), operator));
            }
        });
        return conditions;
    }

    private void doAdd(boolean and, Expression oldWhere, Expression newCondition, boolean isolation) {
        if (oldWhere == null) {
            this.setWhere(newCondition);
            return;
        }
        Object oldConditions = isolation ? (Parenthesis.class.isInstance(oldWhere) ? oldWhere : new Parenthesis(oldWhere)) : oldWhere;
        Object newWhere = and ? new AndExpression(oldConditions, (Expression)(isolation ? new Parenthesis(newCondition) : newCondition)) : new OrExpression(oldConditions, (Expression)(isolation ? new Parenthesis(newCondition) : newCondition));
        this.setWhere((Expression)newWhere);
    }

    private void setWhere(final Expression newWhere) {
        if (this.isSubSelect()) {
            this.getSubSelect().setWhere(newWhere);
        } else {
            this.getStatement().accept((StatementVisitor)new StatementVisitorAdapter(){

                public void visit(Select select) {
                    SelectBody selectBody = select.getSelectBody();
                    if (selectBody != null) {
                        selectBody.accept((SelectVisitor)new SelectVisitorAdapter(){

                            public void visit(PlainSelect plainSelect) {
                                plainSelect.setWhere(newWhere);
                            }
                        });
                    }
                }

                public void visit(Delete delete) {
                    delete.setWhere(newWhere);
                }

                public void visit(Update update) {
                    update.setWhere(newWhere);
                }
            });
        }
        this.where = newWhere;
    }

    private Expression buildExpression(Item condition) throws ProcessorException {
        Expression newCondition;
        String conditionSql = condition.toSqlString();
        try {
            newCondition = CCJSqlParserUtil.parseCondExpression((String)conditionSql);
        }
        catch (JSQLParserException e) {
            throw new ProcessorException(e.getMessage(), e);
        }
        return newCondition;
    }

    private static boolean equalsExpr(Expression c, Expression t) {
        if (!c.getClass().equals(t.getClass())) {
            return false;
        }
        return c.toString().equals(t.toString());
    }

    private Condition buildCondition(Expression left, List<Item> values, ConditionOperator operator) {
        return new Condition(ConversionHelper.convertSmart(left), operator, values);
    }

    private static class RootExpression
    implements Expression {
        private RootExpression() {
        }

        public void accept(ExpressionVisitor expressionVisitor) {
        }

        public SimpleNode getASTNode() {
            return null;
        }

        public void setASTNode(SimpleNode node) {
        }
    }

    private static class FatherInfo {
        private boolean left;
        private Expression expr;

        public FatherInfo(boolean left, Expression expr) {
            this.left = left;
            this.expr = expr;
        }

        public boolean isLeft() {
            return this.left;
        }

        public Expression getExpr() {
            return this.expr;
        }
    }

    private static class RemoveExprVisit
    extends ExpressionVisitorAdapter {
        private Map<Expression, FatherInfo> familyBook;
        private Expression target;

        public RemoveExprVisit(Expression target, Map<Expression, FatherInfo> familyBook) {
            this.target = target;
            this.familyBook = familyBook;
        }

        protected void visitBinaryExpression(BinaryExpression expr) {
            Expression l = expr.getLeftExpression();
            Expression r = expr.getRightExpression();
            this.familyBook.put(l, new FatherInfo(true, (Expression)expr));
            this.familyBook.put(r, new FatherInfo(false, (Expression)expr));
            if (l != null) {
                if (AndExpression.class.isInstance(l) || OrExpression.class.isInstance(l) || Parenthesis.class.isInstance(l)) {
                    l.accept((ExpressionVisitor)new RemoveExprVisit(this.target, this.familyBook));
                } else {
                    this.remove(l, this.target);
                }
            }
            if (r != null) {
                if (AndExpression.class.isInstance(r) || OrExpression.class.isInstance(r) || Parenthesis.class.isInstance(r)) {
                    r.accept((ExpressionVisitor)new RemoveExprVisit(this.target, this.familyBook));
                } else {
                    this.remove(r, this.target);
                }
            }
        }

        private void remove(Expression current, Expression target) {
            if (JSqlParserConditionAbility.equalsExpr(current, target)) {
                FatherInfo fatherInfo = this.familyBook.get(current);
                if (fatherInfo != null) {
                    FatherInfo grandfatherInfo = this.familyBook.get(fatherInfo.getExpr());
                    if (grandfatherInfo != null) {
                        BinaryExpression grandFatherExpr = (BinaryExpression)grandfatherInfo.getExpr();
                        BinaryExpression fatherExpr = (BinaryExpression)fatherInfo.getExpr();
                        if (grandfatherInfo.isLeft()) {
                            if (fatherInfo.left) {
                                grandFatherExpr.setLeftExpression(fatherExpr.getRightExpression());
                            } else {
                                grandFatherExpr.setLeftExpression(fatherExpr.getLeftExpression());
                            }
                        } else if (fatherInfo.left) {
                            grandFatherExpr.setRightExpression(fatherExpr.getRightExpression());
                        } else {
                            grandFatherExpr.setRightExpression(fatherExpr.getLeftExpression());
                        }
                    } else {
                        BinaryExpression fatherExpr = (BinaryExpression)fatherInfo.getExpr();
                        if (fatherInfo.isLeft()) {
                            this.familyBook.put(ROOT_FLAG, new FatherInfo(true, fatherExpr.getRightExpression()));
                        } else {
                            fatherExpr.getLeftExpression();
                            this.familyBook.put(ROOT_FLAG, new FatherInfo(false, fatherExpr.getLeftExpression()));
                        }
                    }
                } else {
                    this.familyBook.put(ROOT_FLAG, new FatherInfo(true, null));
                }
            }
        }
    }
}

