/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.From;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.FieldFromAbility;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.update.Update;

public class JSqlParserUpdateFieldFromAbility
extends AbstractJSqlParserHandler
implements FieldFromAbility {
    public JSqlParserUpdateFieldFromAbility(Statement statement) {
        super(statement, Update.class);
    }

    @Override
    public List<Map.Entry<Field, From>> searchRealTableName(Item item) throws ProcessorException {
        return this.searchRealTableName((Field)item);
    }

    private List<Map.Entry<Field, From>> searchRealTableName(Field field) {
        if (!this.exist(field)) {
            return Collections.emptyList();
        }
        Update update = this.getUpdate();
        if (field.getRef() == null) {
            if (this.noStartJoin() && this.noFromItem() && this.noJoins()) {
                return Arrays.asList(new AbstractMap.SimpleEntry<Field, From>(field, ConversionHelper.convert(update.getTable())));
            }
            return Collections.emptyList();
        }
        List<Map.Entry<Field, From>> froms = null;
        froms = this.doSearchFromTable(field, update.getTable());
        if (froms.isEmpty()) {
            froms = this.doSearchFromStartJoin(field, update.getStartJoins());
        }
        return froms;
    }

    private List<Map.Entry<Field, From>> doSearchFromStartJoin(Field field, List<Join> startJoins) {
        for (Join join : startJoins) {
            List<Map.Entry<Field, From>> froms = this.doSearchFromTable(field, (Table)join.getRightItem());
            if (froms.isEmpty()) continue;
            return froms;
        }
        return Collections.emptyList();
    }

    private List<Map.Entry<Field, From>> doSearchFromTable(Field field, Table table) {
        if (table.getAlias() != null ? table.getAlias().getName().equals(field.getRef()) : table.getName().equals(field.getRef())) {
            return Arrays.asList(new AbstractMap.SimpleEntry<Field, From>(field, ConversionHelper.convert(table)));
        }
        return Collections.emptyList();
    }

    private boolean exist(Field target) {
        List columns = this.getUpdate().getColumns();
        for (Column column : columns) {
            if (!this.equalsFieldAndColumn(target, column)) continue;
            return true;
        }
        List exprs = this.getUpdate().getExpressions();
        for (Expression expr : exprs) {
            if (!Column.class.isInstance(expr) || !this.equalsFieldAndColumn(target, (Column)expr)) continue;
            return true;
        }
        return false;
    }

    private boolean noStartJoin() {
        List joins = this.getUpdate().getStartJoins();
        return joins == null || joins.isEmpty();
    }

    private boolean noFromItem() {
        return this.getUpdate().getFromItem() == null;
    }

    private boolean noJoins() {
        List joins = this.getUpdate().getJoins();
        return joins == null || joins.isEmpty();
    }

    private boolean equalsFieldAndColumn(Field field, Column column) {
        return field.toSqlString().equals(column.toString());
    }
}

