/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define.values;

import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import com.xforceplus.tenant.sql.parser.define.values.Value;
import java.util.Objects;

public class StringValue
implements Value<String> {
    private String value = "";

    public StringValue(String value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public boolean needQuotes() {
        return true;
    }

    @Override
    public String toSqlString() {
        return "'" + this.value + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue that = (StringValue)o;
        return Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }
}

