/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser;

import com.xforceplus.tenant.sql.parser.Sql;
import com.xforceplus.tenant.sql.parser.define.SqlType;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.JDeleteSqlProcessor;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.JInsertSqlProcessor;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.JSelectSqlProcessor;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.JUpdateSqlProcessor;
import com.xforceplus.tenant.sql.parser.processor.SqlProcessor;
import com.xforceplus.tenant.sql.parser.processor.SqlProcessorVisitor;
import com.xforceplus.tenant.sql.parser.processor.UnableOperateSqlProcessor;
import java.util.Objects;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.update.Update;

public class JSql
implements Sql {
    private Statement statement;
    private SqlType type;
    private JSelectSqlProcessor selectSqlProcessor;
    private JUpdateSqlProcessor updateSqlProcessor;
    private JInsertSqlProcessor insertSqlProcessor;
    private JDeleteSqlProcessor deleteSqlProcessor;

    public JSql(Statement statement) {
        this.statement = statement;
        this.parserType();
    }

    @Override
    public SqlProcessor buildProcessor() {
        switch (this.type) {
            case SELECT: {
                if (this.selectSqlProcessor == null) {
                    this.selectSqlProcessor = new JSelectSqlProcessor(this.statement);
                }
                return this.selectSqlProcessor;
            }
            case UPDATE: {
                if (this.updateSqlProcessor == null) {
                    this.updateSqlProcessor = new JUpdateSqlProcessor(this.statement);
                }
                return this.updateSqlProcessor;
            }
            case INSERT: {
                if (this.insertSqlProcessor == null) {
                    this.insertSqlProcessor = new JInsertSqlProcessor(this.statement);
                }
                return this.insertSqlProcessor;
            }
            case DELETE: {
                if (this.deleteSqlProcessor == null) {
                    this.deleteSqlProcessor = new JDeleteSqlProcessor(this.statement);
                }
                return this.deleteSqlProcessor;
            }
        }
        return UnableOperateSqlProcessor.getInstance();
    }

    @Override
    public void visit(SqlProcessorVisitor visitor) {
        SqlProcessor processor = this.buildProcessor();
        switch (this.type) {
            case SELECT: {
                visitor.visit((JSelectSqlProcessor)processor);
                break;
            }
            case UPDATE: {
                visitor.visit((JUpdateSqlProcessor)processor);
                break;
            }
            case INSERT: {
                visitor.visit((JInsertSqlProcessor)processor);
                break;
            }
            case DELETE: {
                visitor.visit((JDeleteSqlProcessor)processor);
                break;
            }
            default: {
                visitor.visit(UnableOperateSqlProcessor.getInstance());
            }
        }
    }

    @Override
    public SqlType type() {
        return this.type;
    }

    @Override
    public boolean isUnion() {
        SelectBody body;
        return SqlType.SELECT == this.type && SetOperationList.class.isInstance(body = ((Select)this.statement).getSelectBody());
    }

    @Override
    public boolean isSub() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSql)) {
            return false;
        }
        JSql jSql = (JSql)o;
        return Objects.equals(this.statement, jSql.statement) && this.type == jSql.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statement, this.type});
    }

    public String toString() {
        return "JSql{statement=" + this.statement + ", type=" + (Object)((Object)this.type) + '}';
    }

    @Override
    public String toSqlString() {
        return this.statement.toString();
    }

    private void parserType() {
        this.type = this.statement instanceof Select ? SqlType.SELECT : (this.statement instanceof Update ? SqlType.UPDATE : (this.statement instanceof Delete ? SqlType.DELETE : (this.statement instanceof Insert ? SqlType.INSERT : SqlType.UNKNOWN)));
    }
}

