/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.Aliasable;
import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.From;
import com.xforceplus.tenant.sql.parser.define.Func;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitorAdapter;
import com.xforceplus.tenant.sql.parser.define.Parentheses;
import com.xforceplus.tenant.sql.parser.define.arithmetic.Arithmeitc;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.JSqlParserSelectItemAbility;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.FieldFromAbility;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;

public class JSqlParserSelectFieldFromAbility
extends AbstractJSqlParserHandler
implements FieldFromAbility {
    public JSqlParserSelectFieldFromAbility(Statement statement) {
        super(statement, Select.class);
    }

    public JSqlParserSelectFieldFromAbility(PlainSelect plainSelect) {
        super(plainSelect);
    }

    @Override
    public List<Map.Entry<Field, From>> searchRealTableName(Item item) throws ProcessorException {
        final ArrayList<Map.Entry<Field, From>> froms = new ArrayList<Map.Entry<Field, From>>();
        item.visit(new ItemVisitorAdapter(){

            @Override
            public void visit(Field field) {
                froms.addAll(JSqlParserSelectFieldFromAbility.this.searchRealTableName(field));
            }

            @Override
            public void visit(Func func) {
                List<Item> parameters = func.getParameters();
                for (Item p : parameters) {
                    if (!Field.class.isInstance(parameters)) continue;
                    froms.addAll(JSqlParserSelectFieldFromAbility.this.searchRealTableName((Field)p));
                }
            }

            @Override
            public void visit(Arithmeitc arithmeitc) {
                Item l = arithmeitc.getLeft();
                Item r = arithmeitc.getRight();
                froms.addAll(JSqlParserSelectFieldFromAbility.this.searchRealTableName(l));
                froms.addAll(JSqlParserSelectFieldFromAbility.this.searchRealTableName(r));
            }

            @Override
            public void visit(Parentheses item) {
                froms.addAll(JSqlParserSelectFieldFromAbility.this.searchRealTableName(item.getItem()));
            }
        });
        return froms;
    }

    private List<Map.Entry<Field, From>> searchRealTableName(final Field field) {
        if (this.isSubSelect()) {
            return this.doSearchFromPlainSelect(field, this.getSubSelect(), true);
        }
        SelectBody body = this.getSelect().getSelectBody();
        final ArrayList<Map.Entry<Field, From>> results = new ArrayList<Map.Entry<Field, From>>();
        body.accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                results.addAll(JSqlParserSelectFieldFromAbility.this.doSearchFromPlainSelect(field, plainSelect, true));
            }

            public void visit(SetOperationList setOpList) {
                results.addAll(JSqlParserSelectFieldFromAbility.this.doSearchFromPlainSelect(field, (PlainSelect)setOpList.getSelects().get(0), true));
            }
        });
        return results;
    }

    private List<Map.Entry<Field, From>> doSearchFromPlainSelect(Field field, PlainSelect plainSelect, boolean equalsSubAlisa) {
        List<Map.Entry<Field, From>> froms = this.doSearchFromItem(field, plainSelect.getFromItem(), equalsSubAlisa);
        if (froms.isEmpty()) {
            froms = this.doSearchJoins(field, plainSelect.getJoins(), equalsSubAlisa);
        }
        return froms;
    }

    private List<Map.Entry<Field, From>> doSearchFromItem(Field field, FromItem fromItem, boolean equalsSubAlisa) {
        if (fromItem == null) {
            return Collections.emptyList();
        }
        if (Table.class.isInstance(fromItem)) {
            Table table = (Table)fromItem;
            if (this.checkTable(field, table)) {
                return Arrays.asList(new AbstractMap.SimpleEntry<Field, From>(field, ConversionHelper.convert(table)));
            }
        } else if (SubSelect.class.isInstance(fromItem)) {
            SubSelect subSelect = (SubSelect)fromItem;
            SelectBody selectBody = subSelect.getSelectBody();
            if (PlainSelect.class.isInstance(selectBody)) {
                Item mappingItem = this.findMappingField(field, (PlainSelect)selectBody);
                if (mappingItem != null) {
                    if (Field.class.isInstance(mappingItem)) {
                        if (equalsSubAlisa && !subSelect.getAlias().getName().equals(field.getRef())) {
                            return Collections.emptyList();
                        }
                        return this.doSearchFromPlainSelect((Field)mappingItem, (PlainSelect)selectBody, false);
                    }
                    if (Func.class.isInstance(mappingItem)) {
                        Func f = (Func)mappingItem;
                        List<Item> parameters = f.getParameters();
                        ArrayList<Map.Entry<Field, From>> froms = new ArrayList<Map.Entry<Field, From>>();
                        if (parameters != null && !parameters.isEmpty()) {
                            for (Item parameter : parameters) {
                                if (!Field.class.isInstance(parameter)) continue;
                                Field parameterField = (Field)parameter;
                                froms.addAll(this.doSearchFromPlainSelect(parameterField, (PlainSelect)selectBody, true));
                            }
                        }
                        if (froms.isEmpty()) {
                            return Collections.emptyList();
                        }
                        return froms;
                    }
                    if (Arithmeitc.class.isInstance(mappingItem)) {
                        return this.iteratorItem(mappingItem, (PlainSelect)selectBody);
                    }
                    if (Parentheses.class.isInstance(mappingItem)) {
                        return this.iteratorItem(mappingItem, (PlainSelect)selectBody);
                    }
                }
            } else if (SetOperationList.class.isInstance(selectBody)) {
                SetOperationList setOperationList = (SetOperationList)selectBody;
                ArrayList<Map.Entry<Field, From>> results = new ArrayList<Map.Entry<Field, From>>();
                for (SelectBody setOperationBody : setOperationList.getSelects()) {
                    results.addAll(this.doSearchFromPlainSelect(field, (PlainSelect)setOperationBody, true));
                }
                return results;
            }
        } else if (SubJoin.class.isInstance(fromItem)) {
            // empty if block
        }
        return Collections.emptyList();
    }

    private List<Map.Entry<Field, From>> iteratorItem(Item item, final PlainSelect select) {
        final ArrayList<Map.Entry<Field, From>> froms = new ArrayList<Map.Entry<Field, From>>();
        final ArrayDeque<Item> queue = new ArrayDeque<Item>();
        queue.add(item);
        while (!queue.isEmpty()) {
            Item currentItem = (Item)queue.poll();
            currentItem.visit(new ItemVisitorAdapter(){

                @Override
                public void visit(Arithmeitc item) {
                    queue.add(item.getLeft());
                    queue.add(item.getRight());
                }

                @Override
                public void visit(Field item) {
                    froms.addAll(JSqlParserSelectFieldFromAbility.this.doSearchFromPlainSelect(item, select, true));
                }

                @Override
                public void visit(Parentheses item) {
                    queue.add(item.getItem());
                }

                @Override
                public void visit(Func func) {
                    for (Item item : func.getParameters()) {
                        if (Field.class.isInstance(item)) {
                            this.visit((Field)item);
                            continue;
                        }
                        queue.add(item);
                    }
                }
            });
        }
        if (froms.isEmpty()) {
            return Collections.emptyList();
        }
        return froms;
    }

    private List<Map.Entry<Field, From>> doSearchJoins(Field field, List<Join> joins, boolean equalsSubAlisa) {
        if (joins == null) {
            return Collections.emptyList();
        }
        for (Join join : joins) {
            List<Map.Entry<Field, From>> froms = this.doSearchFromItem(field, join.getRightItem(), equalsSubAlisa);
            if (froms.isEmpty()) continue;
            return froms;
        }
        return Collections.emptyList();
    }

    private Item findMappingField(Field source, PlainSelect select) {
        JSqlParserSelectItemAbility selectItemAbility = new JSqlParserSelectItemAbility(select);
        List<Item> selectItems = selectItemAbility.list();
        for (Item item : selectItems) {
            if (!(Field.class.isInstance(item) ? this.isTheSameField(source, (Field)item) : (Func.class.isInstance(item) || Arithmeitc.class.isInstance(item) || Parentheses.class.isInstance(item)) && this.isTheSameField(source, (Aliasable)((Object)item)))) continue;
            return item;
        }
        return null;
    }

    private boolean isTheSameField(Field source, Aliasable target) {
        if (target.getAlias() != null) {
            return source.getName().equals(target.getAlias().getName());
        }
        return false;
    }

    private boolean isTheSameField(Field source, Field target) {
        if (target.getAlias() != null) {
            return source.getName().equals(target.getAlias().getName());
        }
        return source.getName().equals(target.getName());
    }

    private boolean checkTable(Field field, Table table) {
        if (table.getAlias() != null) {
            return table.getAlias().getName().equals(field.getRef());
        }
        return table.getName().equals(field.getRef());
    }
}

