/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define;

import com.xforceplus.tenant.sql.parser.define.Alias;
import com.xforceplus.tenant.sql.parser.define.Aliasable;
import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import com.xforceplus.tenant.sql.parser.define.values.Value;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Func
extends Aliasable
implements Item {
    private String name;
    private List<Item> parameters;

    public Func(String name) {
        this(name, null, null);
    }

    public Func(String name, Alias alias) {
        this(name, null, alias);
    }

    public Func(String name, List<Item> parameters) {
        this(name, parameters, null);
    }

    public Func(String name, List<Item> parameters, Alias alias) {
        super(alias);
        this.name = name;
        List<Item> list = this.parameters = parameters != null ? parameters : Collections.emptyList();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid function name.");
        }
        int index = this.name.indexOf(40);
        if (index > 0) {
            this.name = this.name.substring(0, index);
        }
        if (parameters != null && !parameters.isEmpty()) {
            parameters.stream().forEach(p -> {
                if (!(Field.class.isInstance(p) || Value.class.isInstance(p) || Func.class.isInstance(p))) {
                    throw new IllegalArgumentException("Only Column, Value and Function can be received!");
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Item> getParameters() {
        return this.parameters;
    }

    public boolean hasParameter() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "Funcion{name='" + this.name + '\'' + ", alias='" + (this.hasAlias() ? this.getAlias() : "null") + '\'' + ", parameters=" + this.parameters + '}';
    }

    @Override
    public String toSqlString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name).append("(");
        if (this.hasParameter()) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(this.parameters.get(i).toSqlString());
            }
        }
        buff.append(")");
        if (this.hasAlias()) {
            buff.append(this.getAlias().toSqlString());
        }
        return buff.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Func)) {
            return false;
        }
        Func func = (Func)o;
        return Objects.equals(this.getName(), func.getName()) && Objects.equals(this.getParameters(), func.getParameters()) && Objects.equals(this.getAlias(), func.getAlias());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getParameters(), this.getAlias());
    }
}

