/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.Func;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import com.xforceplus.tenant.sql.parser.define.values.Value;
import java.util.Objects;

public class UpdateSet
implements Item {
    private Field field;
    private Item value;

    public UpdateSet(Field field, Value value) {
        this.field = field;
        this.value = value;
    }

    public UpdateSet(Field field, Func function) {
        this.field = field;
        this.value = function;
    }

    public Field getField() {
        return this.field;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public boolean isValueSet() {
        return Value.class.isInstance(this.value);
    }

    public boolean isFuncSet() {
        return Func.class.isInstance(this.value);
    }

    @Override
    public String toSqlString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.field.toSqlString());
        buff.append(" = ");
        buff.append(this.value.toSqlString());
        return buff.toString();
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSet)) {
            return false;
        }
        UpdateSet updateSet = (UpdateSet)o;
        return Objects.equals(this.getField(), updateSet.getField()) && Objects.equals(this.getValue(), updateSet.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.getValue());
    }

    public String toString() {
        return "UpdateSet{field=" + this.field + ", value=" + this.value + '}';
    }
}

