/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.auth.grpc.client;

import com.xforceplus.tenant.data.auth.grpc.AuthorizationGrpc;
import com.xforceplus.tenant.data.auth.grpc.ForObjectGrpc;
import com.xforceplus.tenant.data.auth.grpc.ObjectAgreementGrpc;
import com.xforceplus.tenant.data.auth.grpc.ObjectCheckServiceGrpc;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import com.xforceplus.tenant.data.domain.check.ObjectAgreementAuthorization;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCheckClientGrpc {
    final Logger logger = LoggerFactory.getLogger(ObjectCheckClientGrpc.class);
    private String host = "uc-data-auth";
    private int port = 8206;
    private long heartbeatIntervalSeconds = 30L;
    private long heartbeatTimeoutSeconds = 30L;
    private long readTimeMs = 200L;
    private ManagedChannel channel;
    private ObjectCheckServiceGrpc.ObjectCheckServiceBlockingStub stub;

    public void init() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().keepAliveTime(this.heartbeatIntervalSeconds, TimeUnit.SECONDS).keepAliveTimeout(this.heartbeatTimeoutSeconds, TimeUnit.SECONDS).build();
        this.stub = ObjectCheckServiceGrpc.newBlockingStub((Channel)this.channel);
        this.logger.info("uc-data-auth-client successfully connects to {}:{}.!", (Object)this.host, (Object)this.port);
    }

    public void destroy() throws InterruptedException {
        this.channel.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
    }

    public ForObjectGrpc.ObjectCheckResult check(ObjectAgreementAuthorization oaa) {
        ObjectAgreementGrpc.ObjectAgreement.Builder objectAgreementBuilder = ObjectAgreementGrpc.ObjectAgreement.newBuilder().setResourcecode(oaa.getResourceCode()).setEntityCode(oaa.getEntityCode()).setContent(oaa.getContent());
        Authorization auth = oaa.getAuthorization();
        for (AuthorizedUser user : auth.getAuthorizedUsers()) {
            for (Long roleId : user.getRoleIds()) {
                objectAgreementBuilder.addAuthorization(AuthorizationGrpc.Authorization.newBuilder().setAppid(user.getAppId().toString()).setResourcecode(oaa.getResourceCode()).setUser(user.getUserId().toString()).setRole(roleId.toString()).setTenant(user.getTenantId().toString()).build());
            }
        }
        ForObjectGrpc.Agreement.Builder builder = ForObjectGrpc.Agreement.newBuilder().setAgreement(objectAgreementBuilder.build());
        return ((ObjectCheckServiceGrpc.ObjectCheckServiceBlockingStub)this.stub.withDeadlineAfter(this.readTimeMs, TimeUnit.MILLISECONDS)).check(builder.build());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(long heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public long getHeartbeatTimeoutSeconds() {
        return this.heartbeatTimeoutSeconds;
    }

    public void setHeartbeatTimeoutSeconds(long heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
    }

    public long getReadTimeMs() {
        return this.readTimeMs;
    }

    public void setReadTimeMs(long readTimeMs) {
        this.readTimeMs = readTimeMs;
    }
}

