package com.xforceplus.tenant.data.auth.grpc.client;

import com.xforceplus.tenant.data.auth.grpc.ForObjectGrpc;
import com.xforceplus.tenant.data.auth.grpc.ObjectAgreementGrpc;
import com.xforceplus.tenant.data.auth.grpc.ObjectAgreementGrpc.ObjectAgreement;
import com.xforceplus.tenant.data.auth.grpc.ObjectCheckServiceGrpc;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import com.xforceplus.tenant.data.domain.check.ObjectAgreementAuthorization;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * @author zhouxinßß
 */
public class ObjectCheckClientGrpc {

    final Logger logger = LoggerFactory.getLogger(ObjectCheckClientGrpc.class);

    private String host = "uc-data-auth";
    private int port = 8206;
    private long heartbeatIntervalSeconds = 30;
    private long heartbeatTimeoutSeconds = 30;
    private long readTimeMs = 200L;

    private ManagedChannel channel;
    private ObjectCheckServiceGrpc.ObjectCheckServiceBlockingStub stub;

    public void init() {

        channel = ManagedChannelBuilder
            .forAddress(host, port)
            .usePlaintext()
            .keepAliveTime(heartbeatIntervalSeconds, TimeUnit.SECONDS)
            .keepAliveTimeout(heartbeatTimeoutSeconds, TimeUnit.SECONDS)
            .build();

        stub = ObjectCheckServiceGrpc.newBlockingStub(channel);

        logger.info("uc-data-auth-client successfully connects to {}:{}.!",host,port);
    }

    public void destroy() throws InterruptedException {
        channel.shutdown().awaitTermination(30L, TimeUnit.SECONDS);

    }

    public ForObjectGrpc.ObjectCheckResult check(ObjectAgreementAuthorization oaa) {
        ObjectAgreement.Builder objectAgreementBuilder = ObjectAgreementGrpc.ObjectAgreement
            .newBuilder()
            .setResourcecode(oaa.getResourceCode())
            .setEntityCode(oaa.getEntityCode())
            .setContent(oaa.getContent());

        Authorization auth = oaa.getAuthorization();
        for (AuthorizedUser user : auth.getAuthorizedUsers()) {
            for(Long roleId : user.getRoleIds()) {
                objectAgreementBuilder.addAuthorization(com.xforceplus.tenant.data.auth.grpc.AuthorizationGrpc.Authorization
                    .newBuilder()
                    .setAppid(user.getAppId().toString())
                    .setResourcecode(oaa.getResourceCode())
                    .setUser(user.getUserId().toString())
                    .setRole(roleId.toString())
                    .setTenant(user.getTenantId().toString()).build());
            }
        }

        ForObjectGrpc.Agreement.Builder builder = ForObjectGrpc.Agreement
            .newBuilder()
            .setAgreement(objectAgreementBuilder.build());

        return stub
            .withDeadlineAfter(readTimeMs, TimeUnit.MILLISECONDS)
            .check(builder.build());
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getHeartbeatIntervalSeconds() {
        return heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(long heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public long getHeartbeatTimeoutSeconds() {
        return heartbeatTimeoutSeconds;
    }

    public void setHeartbeatTimeoutSeconds(long heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
    }

    public long getReadTimeMs() {
        return readTimeMs;
    }

    public void setReadTimeMs(long readTimeMs) {
        this.readTimeMs = readTimeMs;
    }
}
