package com.xforceplus.tenant.data.auth.grpc.client;

import com.xforceplus.tenant.data.auth.grpc.ForStatmentGrpc;
import com.xforceplus.tenant.data.auth.grpc.StatmentCheckServiceGrpc;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * grpc 实现.
 *
 * @version 0.1 2019/11/15 14:42
 * @author dongbin
 * @since 1.8
 */
public class StatmentCheckClientGrpc {

    final Logger logger = LoggerFactory.getLogger(StatmentCheckClientGrpc.class);

    private String host = "uc-data-auth";
    private int port = 8206;
    private long heartbeatIntervalSeconds = 30;
    private long heartbeatTimeoutSeconds = 30;
    private long readTimeMs = 200L;

    private ManagedChannel channel;
    private StatmentCheckServiceGrpc.StatmentCheckServiceBlockingStub stub;

    public void init() {

        channel = ManagedChannelBuilder.forAddress(host, port)
            .usePlaintext()
            .keepAliveTime(heartbeatIntervalSeconds, TimeUnit.SECONDS)
            .keepAliveTimeout(heartbeatTimeoutSeconds, TimeUnit.SECONDS)
            .build();

        stub = StatmentCheckServiceGrpc.newBlockingStub(channel);

        logger.info("uc-data-auth-client successfully connects to {}:{}.!",host,port);
    }

    public void destroy() throws InterruptedException {
        channel.shutdown().awaitTermination(30L, TimeUnit.SECONDS);

    }

    public ForStatmentGrpc.StatmentResult check(String sql, Authorization authorization) {
        ForStatmentGrpc.Statment.Builder builder = ForStatmentGrpc.Statment.newBuilder().setSql(sql);

        for (AuthorizedUser user : authorization.getAuthorizedUsers()) {
            for(Long roleId : user.getRoleIds()) {
                builder.addAuthorization(com.xforceplus.tenant.data.auth.grpc.AuthorizationGrpc.Authorization
                            .newBuilder()
                            .setAppid(user.getAppId().toString())
                            .setResourcecode(authorization.getResourceCode())
                            .setUser(user.getUserId().toString())
                            .setRole(roleId.toString())
                            .setTenant(user.getTenantId().toString()).build());
            }
        }

        return stub.withDeadlineAfter(readTimeMs, TimeUnit.MILLISECONDS).check(builder.build());
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getHeartbeatIntervalSeconds() {
        return heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(long heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public long getHeartbeatTimeoutSeconds() {
        return heartbeatTimeoutSeconds;
    }

    public void setHeartbeatTimeoutSeconds(long heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
    }

    public long getReadTimeMs() {
        return readTimeMs;
    }

    public void setReadTimeMs(long readTimeMs) {
        this.readTimeMs = readTimeMs;
    }
}
