/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.auth.config;

import com.xforceplus.tenant.data.auth.grpc.ForStatmentGrpc;
import com.xforceplus.tenant.data.auth.grpc.StatmentCheckServiceGrpc;
import com.xforceplus.tenant.data.auth.service.RuleCheckService;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import com.xforceplus.tenant.data.domain.check.SqlChange;
import com.xforceplus.tenant.data.domain.result.CheckResult;
import com.xforceplus.tenant.data.domain.result.CheckStatus;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.lognet.springboot.grpc.GRpcService;

@GRpcService
public class GrpcStatmentCheckService
extends StatmentCheckServiceGrpc.StatmentCheckServiceImplBase {
    @Resource
    private RuleCheckService ruleCheckService;

    public void check(ForStatmentGrpc.Statment request, StreamObserver<ForStatmentGrpc.StatmentResult> responseObserver) {
        String sql = request.getSql();
        List authorizationList = request.getAuthorizationList();
        Authorization authorization = new Authorization();
        HashMap userMap = new HashMap();
        authorizationList.forEach(a -> {
            AuthorizedUser user = (AuthorizedUser)userMap.get(a.getUser());
            if (null == user) {
                user = new AuthorizedUser();
                user.setAppId(Long.valueOf(Long.parseLong(a.getAppid())));
                user.setUserId(Long.valueOf(Long.parseLong(a.getUser())));
                user.setTenantId(Long.valueOf(Long.parseLong(a.getTenant())));
                HashSet<Long> roleIds = new HashSet<Long>();
                roleIds.add(Long.parseLong(a.getRole()));
                user.setRoleIds(roleIds);
            } else {
                user.getRoleIds().add(Long.parseLong(a.getRole()));
            }
            userMap.put(a.getUser(), user);
            if (StringUtils.isBlank((CharSequence)authorization.getResourceCode())) {
                authorization.setResourceCode(a.getResourcecode());
            }
        });
        authorization.setAuthorizedUsers(new HashSet(userMap.values()));
        CheckResult result = this.ruleCheckService.check(sql, authorization);
        ForStatmentGrpc.StatmentResult.Builder builder = ForStatmentGrpc.StatmentResult.newBuilder();
        builder.setStatus(((CheckStatus)result.getStatus()).getValue());
        builder.setMessage(result.getMessage());
        Optional sqlChangeOptional = result.streamValues().findFirst();
        if (sqlChangeOptional.isPresent()) {
            SqlChange change = (SqlChange)sqlChangeOptional.get();
            if (change.getBlackList() != null) {
                for (String field : change.getBlackList()) {
                    builder.addBackList(field);
                }
            }
            if (change.getNewSql() != null) {
                builder.setNewSql(change.getNewSql());
            }
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }
}

