/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsso.component;

import com.google.common.net.InternetDomainName;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class CookieUtils {
    private static final Logger logger = LoggerFactory.getLogger(CookieUtils.class);

    public static String getCookieValue(ServerHttpRequest request, String cookieName) {
        String token = null;
        MultiValueMap cookies = request.getCookies();
        List cookie = (List)cookies.get((Object)cookieName);
        if (cookie != null && !cookie.isEmpty()) {
            token = ((HttpCookie)cookie.get(0)).getValue();
        }
        if (StringUtils.isBlank(token)) {
            HttpHeaders headers = request.getHeaders();
            token = headers.getFirst(cookieName);
        }
        return token;
    }

    public static void deleteCookie(String key, ServerWebExchange exchange) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from((String)key, null).maxAge(0L).path("/");
        CookieUtils.setPrivateDomain(exchange, builder);
        ResponseCookie cookie = builder.build();
        exchange.getResponse().addCookie(cookie);
    }

    private static void setPrivateDomain(ServerWebExchange exchange, ResponseCookie.ResponseCookieBuilder builder) {
        String domain = exchange.getRequest().getURI().getHost();
        try {
            domain = InternetDomainName.from((String)domain).topPrivateDomain().toString();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        builder.domain(domain);
    }
}

