/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsso.component;

import com.xforceplus.tenantsso.component.CookieUtils;
import com.xforceplus.tenantsso.component.SsoUserinfoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=10)
public class SsoFilter
implements WebFilter {
    private SsoUserinfoService ssoUserinfoService;

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        if (this.ssoUserinfoService != null) {
            String token = CookieUtils.getCookieValue(serverWebExchange.getRequest(), "xforce-saas-token");
            if (StringUtils.isBlank((CharSequence)token)) {
                token = CookieUtils.getCookieValue(serverWebExchange.getRequest(), "x-app-token");
            }
            if (StringUtils.isBlank((CharSequence)token)) {
                this.ssoUserinfoService.extractUserinfo(serverWebExchange);
            }
        }
        return webFilterChain.filter(serverWebExchange);
    }

    public SsoUserinfoService getSsoUserinfoService() {
        return this.ssoUserinfoService;
    }

    public void setSsoUserinfoService(SsoUserinfoService ssoUserinfoService) {
        this.ssoUserinfoService = ssoUserinfoService;
    }
}

