/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.errorCode;

import com.xforceplus.tower.common.errorCode.TowerErrorCode;

public enum BasicErrorCode implements TowerErrorCode
{
    SystemError(100001, "\u7cfb\u7edf\u9519\u8bef"),
    NotAuthError(100401, "\u672a\u901a\u8fc7\u7528\u6237\u4e2d\u5fc3\u7f51\u5173\u8c03\u7528\u9519\u8bef"),
    ParameterError(100403, "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");

    private int code;
    private String msg;

    private BasicErrorCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public static TowerErrorCode get(int code) {
        for (BasicErrorCode i : BasicErrorCode.values()) {
            if (i.getCode() != code) continue;
            return i;
        }
        return SystemError;
    }

    public TowerErrorCode valueOf(int code) {
        return BasicErrorCode.get(code);
    }
}

