/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.http;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpClientProxy
implements Client {
    Logger logger = LoggerFactory.getLogger(OkHttpClientProxy.class);
    private final OkHttpClient delegate;

    public OkHttpClientProxy() {
        this(new OkHttpClient());
    }

    public OkHttpClientProxy(OkHttpClient delegate) {
        this.delegate = delegate;
    }

    static okhttp3.Request toOkHttpRequest(Request input) {
        boolean isMethodWithBody;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(input.url());
        requestBuilder.addHeader("token", "zhaochaoerewrserewrdd");
        MediaType mediaType = null;
        boolean hasAcceptHeader = false;
        for (String field : input.headers().keySet()) {
            if (field.equalsIgnoreCase("Accept")) {
                hasAcceptHeader = true;
            }
            for (String value : (Collection)input.headers().get(field)) {
                requestBuilder.addHeader(field, value);
                if (!field.equalsIgnoreCase("Content-Type")) continue;
                mediaType = MediaType.parse((String)value);
                if (input.charset() == null) continue;
                mediaType.charset(input.charset());
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader("Accept", "*/*");
        }
        byte[] inputBody = input.body();
        boolean bl = isMethodWithBody = Request.HttpMethod.POST == input.httpMethod() || Request.HttpMethod.PUT == input.httpMethod() || Request.HttpMethod.PATCH == input.httpMethod();
        if (isMethodWithBody) {
            requestBuilder.removeHeader("Content-Type");
            if (inputBody == null) {
                inputBody = new byte[]{};
            }
        }
        RequestBody body = inputBody != null ? RequestBody.create(mediaType, (byte[])inputBody) : null;
        requestBuilder.method(input.httpMethod().name(), body);
        return requestBuilder.build();
    }

    private static Response toFeignResponse(okhttp3.Response response, Request request) throws IOException {
        return Response.builder().status(response.code()).reason(response.message()).request(request).headers(OkHttpClientProxy.toMap(response.headers())).body(OkHttpClientProxy.toBody(response.body())).build();
    }

    private static Map<String, Collection<String>> toMap(Headers headers) {
        return headers.toMultimap();
    }

    private static Response.Body toBody(final ResponseBody input) throws IOException {
        if (input == null || input.contentLength() == 0L) {
            if (input != null) {
                input.close();
            }
            return null;
        }
        final Integer length = input.contentLength() >= 0L && input.contentLength() <= Integer.MAX_VALUE ? Integer.valueOf((int)input.contentLength()) : null;
        return new Response.Body(){

            public void close() throws IOException {
                input.close();
            }

            public Integer length() {
                return length;
            }

            public boolean isRepeatable() {
                return false;
            }

            public InputStream asInputStream() throws IOException {
                return input.byteStream();
            }

            public Reader asReader() throws IOException {
                return input.charStream();
            }

            public Reader asReader(Charset charset) throws IOException {
                return this.asReader();
            }
        };
    }

    public Response execute(Request input, Request.Options options) throws IOException {
        OkHttpClient requestScoped = this.delegate.connectTimeoutMillis() != options.connectTimeoutMillis() || this.delegate.readTimeoutMillis() != options.readTimeoutMillis() ? this.delegate.newBuilder().connectTimeout((long)options.connectTimeoutMillis(), TimeUnit.MILLISECONDS).readTimeout((long)options.readTimeoutMillis(), TimeUnit.MILLISECONDS).followRedirects(options.isFollowRedirects()).build() : this.delegate;
        okhttp3.Request request = OkHttpClientProxy.toOkHttpRequest(input);
        okhttp3.Response response = requestScoped.newCall(request).execute();
        return OkHttpClientProxy.toFeignResponse(response, input).toBuilder().request(input).build();
    }
}

