/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.http;

import com.xforceplus.tower.common.http.OkHttpClientProxy;
import feign.Client;
import feign.okhttp.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OkHttpClient.class, CachingSpringLoadBalancerFactory.class, SpringClientFactory.class, okhttp3.OkHttpClient.class})
@ConditionalOnProperty(value={"feign.okhttp.enabled"})
public class OkHttpClientProxyConfiguration {
    @Bean
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory, okhttp3.OkHttpClient okHttpClient) {
        OkHttpClientProxy delegate = new OkHttpClientProxy(okHttpClient);
        return new LoadBalancerFeignClient((Client)delegate, cachingFactory, clientFactory);
    }
}

