/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.response;

import com.xforceplus.tower.common.errorCode.BasicErrorCode;
import com.xforceplus.tower.common.errorCode.TowerErrorCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

@ApiModel(value="\u8bf7\u6c42\u8fd4\u56de\u6570\u636e")
public class Response<T>
implements Serializable {
    @ApiModelProperty(value="\u9519\u8bef\u7801")
    public int code;
    @ApiModelProperty(value="\u9519\u8bef\u4fe1\u606f")
    public String message;
    @ApiModelProperty(value="\u4e1a\u52a1\u6570\u636e")
    public T result;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public static Response success(String message, Object result) {
        Response<Object> rtn = new Response<Object>();
        rtn.setMessage(message);
        rtn.setResult(result);
        return rtn;
    }

    public static Response success(Object result) {
        Response<Object> rtn = new Response<Object>();
        rtn.setResult(result);
        return rtn;
    }

    public static Response fail() {
        Response rtn = new Response();
        rtn.setCode(BasicErrorCode.SystemError.getCode());
        rtn.setMessage(BasicErrorCode.SystemError.getMsg());
        return rtn;
    }

    public static Response fail(TowerErrorCode errorCode) {
        if (errorCode == null) {
            return null;
        }
        Response rtn = new Response();
        rtn.setCode(errorCode.getCode());
        rtn.setMessage(errorCode.getMsg());
        return rtn;
    }

    public static Response fail(TowerErrorCode errorCode, Object result) {
        if (errorCode == null) {
            return null;
        }
        Response<Object> rtn = new Response<Object>();
        rtn.setCode(errorCode.getCode());
        rtn.setMessage(errorCode.getMsg());
        rtn.setResult(result);
        return rtn;
    }

    public static Response failOfMsg(TowerErrorCode errorCode, String msg) {
        if (errorCode == null) {
            return null;
        }
        Response rtn = new Response();
        rtn.setCode(errorCode.getCode());
        rtn.setMessage(errorCode.getMsg());
        if (StringUtils.isNotBlank((String)msg)) {
            rtn.setMessage(msg);
        }
        return rtn;
    }

    public String toString() {
        return "Response{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}

