/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.track.properties.provider.impl;

import com.xforceplus.tower.common.track.properties.provider.XplatProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatProviderManager;
import com.xforceplus.tower.common.track.properties.provider.impl.DefaultXplatAppIdProvider;
import com.xforceplus.tower.common.track.properties.provider.impl.DefaultXplatAppVersionProvider;
import com.xforceplus.tower.common.track.properties.provider.impl.XplatNullProviderManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDefaultXplatProviderManager
implements XplatProviderManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDefaultXplatProviderManager.class);
    private Map<Class<? extends XplatProvider>, XplatProvider> mProviders = new LinkedHashMap<Class<? extends XplatProvider>, XplatProvider>();

    public AbstractDefaultXplatProviderManager() {
        DefaultXplatAppIdProvider applicationProvider = new DefaultXplatAppIdProvider();
        applicationProvider.initialize();
        this.register(applicationProvider);
        DefaultXplatAppVersionProvider defaultXplatAppVersionProvider = new DefaultXplatAppVersionProvider();
        defaultXplatAppVersionProvider.initialize();
        this.register(defaultXplatAppVersionProvider);
    }

    public synchronized void register(XplatProvider provider) {
        this.mProviders.put(provider.getType(), provider);
    }

    @Override
    public <T extends XplatProvider> XplatProvider provider(Class<T> clazz) {
        XplatProvider provider = this.mProviders.get(clazz);
        if (provider != null) {
            return provider;
        }
        logger.error("No provider [{}] found in DefaultXplatProviderManager, please make sure it is registered in DefaultProviderManager ", (Object)clazz.getName());
        return XplatNullProviderManager.PROVIDER;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        XplatProvider provider;
        String value;
        Iterator<XplatProvider> var3 = this.mProviders.values().iterator();
        do {
            if (var3.hasNext()) continue;
            return defaultValue;
        } while ((value = (provider = var3.next()).getProperty(name, null)) == null);
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        if (null != this.mProviders) {
            for (Map.Entry<Class<? extends XplatProvider>, XplatProvider> entry : this.mProviders.entrySet()) {
                sb.append(entry.getValue()).append("\n");
            }
        }
        sb.append("(DefaultProviderManager)").append("\n");
        return sb.toString();
    }
}

