/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.data.convert.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.tower.data.convert.exception.ExcelToJsonException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelConvertListener
extends AnalysisEventListener {
    private static Logger logger = LoggerFactory.getLogger(ExcelConvertListener.class);
    private static final String replace_key1 = "${";
    private static final String replace_key2 = "}";
    private static final String rgex = "\\$\\{(.*?)}";
    private List<Map> data = Lists.newArrayList();
    private String json;
    private List<String> excelHeaders = Lists.newArrayList();

    public void invoke(Object object, AnalysisContext context) {
        if (ObjectUtils.isEmpty(this.excelHeaders)) {
            this.excelHeaders.addAll((ArrayList)object);
        } else {
            String tempJson;
            ArrayList values = (ArrayList)object;
            if (values.size() < this.excelHeaders.size()) {
                int size = this.excelHeaders.size() - values.size();
                for (int i = 0; i < size; ++i) {
                    values.add("");
                }
            }
            if ((tempJson = this.replaceJson(this.json, this.excelHeaders, values)).contains(replace_key1) && tempJson.contains(replace_key2)) {
                logger.info("excelHeaders:{}", this.excelHeaders);
                logger.info("jsonTemplate:{}", (Object)this.json);
                logger.error("errorjson:{}", (Object)tempJson);
                throw new ExcelToJsonException("convert fail , please check fields " + JSON.toJSONString(this.getErrorSub(tempJson, rgex)));
            }
            Map map = (Map)JSON.parseObject((String)tempJson, Map.class);
            this.data.add(map);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        logger.info("doAfterAllAnalysed");
    }

    private String replaceJson(String json, List<String> excelHeaders, ArrayList<String> values) {
        for (int i = 0; i < excelHeaders.size(); ++i) {
            String key = replace_key1 + excelHeaders.get(i).trim() + replace_key2;
            String value = values.get(i) == null ? "" : values.get(i);
            json = json.replace(key, value);
        }
        return json;
    }

    private List<String> getErrorSub(String json, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher matcher = pattern.matcher(json);
        ArrayList list = Lists.newArrayList();
        while (matcher.find()) {
            int i = 1;
            list.add(matcher.group(i));
            ++i;
        }
        return list;
    }

    public List<Map> getData() {
        return this.data;
    }

    public void setData(List<Map> data) {
        this.data = data;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }
}

