/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.data.convert.util;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.metadata.TableStyle;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.tower.data.convert.exception.ExcelToJsonException;
import com.xforceplus.tower.data.convert.listener.ExcelConvertListener;
import com.xforceplus.tower.data.convert.model.ExcelToJsonProperty;
import com.xforceplus.tower.data.convert.model.JsonToExcelProperty;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ExcelConvertUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelConvertUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String excelToJson(ExcelToJsonProperty property) {
        ExcelConvertUtil.checkProperties(property);
        MultipartFile file = property.getFile();
        String json = property.getJson().replaceAll("\\s+", "");
        Integer startRow = property.getStartRow();
        Integer startSheet = property.getStartSheet();
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String string = ExcelConvertUtil.generateInputStreamToJson(inputStream, json, startRow, startSheet);
            return string;
        }
        catch (ExcelToJsonException | IOException e) {
            logger.error("excelToJson exception", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("excelToJson Io Exception ", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jsonToExcel(List<JsonToExcelProperty> properties, String fileName) {
        ExcelConvertUtil.checkJsonToExcelProperty(properties, fileName);
        FileOutputStream out = null;
        ExcelWriter writer = null;
        try {
            out = new FileOutputStream(fileName);
            writer = EasyExcelFactory.getWriter((OutputStream)out);
            for (int i = 0; i < properties.size(); ++i) {
                JsonToExcelProperty property = properties.get(i);
                String sheetName = ObjectUtils.isEmpty((Object)property.getSheetName()) ? "sheet" + i++ : property.getSheetName();
                String json = property.getJson();
                Map<String, String> rules = property.getRules();
                List<List<String>> headers = ExcelConvertUtil.createTestListStringHead(json, rules);
                Sheet sheet = new Sheet(i + 1, 0);
                sheet.setSheetNo(i + 1);
                sheet.setSheetName(sheetName);
                sheet.setHead(headers);
                TableStyle tableStyle = new TableStyle();
                tableStyle.setTableContentBackGroundColor(IndexedColors.WHITE);
                sheet.setTableStyle(tableStyle);
                List<List<Object>> datas = ExcelConvertUtil.createTestListObject(json, rules);
                writer.write1(datas, sheet);
            }
        }
        catch (Exception e) {
            logger.error("jsonToExcel error :", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.finish();
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    logger.error("outinputstream close error ", (Throwable)e);
                }
            }
        }
    }

    private static String generateInputStreamToJson(InputStream inputStream, String json, Integer startRow, Integer startSheet) {
        ExcelConvertListener excelListener = new ExcelConvertListener();
        excelListener.setJson(json);
        ExcelReader excelReader = EasyExcelFactory.getReader((InputStream)inputStream, (AnalysisEventListener)excelListener);
        List sheets = excelReader.getSheets();
        logger.info("all sheets {}", (Object)sheets);
        if (ObjectUtils.isEmpty((Object)sheets)) {
            throw new ExcelToJsonException("current excel has no sheet,please import a right excel!");
        }
        ArrayList datas = Lists.newArrayList();
        for (int i = startSheet - 1; i < sheets.size(); ++i) {
            Sheet sheet = (Sheet)sheets.get(i);
            sheet.setHeadLineMun(startRow - 1);
            excelReader.read(sheet);
            List<Map> data = excelListener.getData();
            datas.addAll(data);
        }
        if (ObjectUtils.isEmpty((Object)datas)) {
            throw new ExcelToJsonException("convert result is '[]' ,please check your file or request params is correct!");
        }
        return JSON.toJSONString((Object)datas);
    }

    private static List<List<Object>> createTestListObject(String json, Map<String, String> rules) {
        List maps = JSONObject.parseArray((String)json, LinkedHashMap.class);
        ArrayList datas = Lists.newArrayList();
        for (Map map : maps) {
            ArrayList keys = new ArrayList(map.keySet());
            ArrayList<String> ruleKeys = new ArrayList<String>(rules.keySet());
            ArrayList values = Lists.newArrayList();
            keys.stream().forEach(k -> {
                if (ruleKeys.contains(k)) {
                    String value = (String)map.get(k);
                    if (ObjectUtils.isEmpty((Object)value)) {
                        value = "";
                    }
                    values.add(value);
                }
            });
            datas.add(values);
        }
        return datas;
    }

    private static List<List<String>> createTestListStringHead(String json, Map<String, String> rules) {
        List datas = JSONObject.parseArray((String)json, LinkedHashMap.class);
        Map map = (Map)datas.get(0);
        ArrayList headers = Lists.newArrayList();
        for (String key : map.keySet()) {
            ArrayList header = Lists.newArrayList();
            String chinessHeader = rules.get(key);
            if (ObjectUtils.isEmpty((Object)chinessHeader)) continue;
            header.add(chinessHeader);
            headers.add(header);
        }
        return headers;
    }

    private static void checkJsonToExcelProperty(List<JsonToExcelProperty> propertys, String fileName) {
        if (ObjectUtils.isEmpty(propertys)) {
            throw new ExcelToJsonException("properties can not be empty!");
        }
        for (JsonToExcelProperty property : propertys) {
            String json = property.getJson();
            Map<String, String> rules = property.getRules();
            Objects.requireNonNull(rules, "rules can not be null!");
            if (!ObjectUtils.isEmpty((Object)json)) continue;
            throw new ExcelToJsonException("json can not be null!");
        }
        Objects.requireNonNull(fileName, "fileName can not be null!");
        if (!fileName.endsWith(ExcelTypeEnum.XLS.getValue()) && !fileName.endsWith(ExcelTypeEnum.XLSX.getValue())) {
            throw new ExcelToJsonException("excel must endwith .xls or .xlsx!");
        }
    }

    private static void checkProperties(ExcelToJsonProperty property) {
        MultipartFile file = property.getFile();
        String json = property.getJson();
        String filename = file.getOriginalFilename();
        Integer startRow = property.getStartRow();
        Integer startSheet = property.getStartSheet();
        Objects.requireNonNull(file, "file can not be null!");
        Objects.requireNonNull(filename, "fileName can not be null!");
        if (ObjectUtils.isEmpty((Object)json)) {
            throw new ExcelToJsonException("the result json can not be null!");
        }
        if (!filename.endsWith(ExcelTypeEnum.XLS.getValue()) && !filename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
            throw new ExcelToJsonException("excel must endwith .xls or .xlsx!");
        }
        if (startRow <= 0 || startSheet <= 0) {
            throw new ExcelToJsonException("\u5f00\u59cb\u7684\u884cstartRow \u6216\u8005 \u5f00\u59cb\u8bfb\u53d6\u7684sheet \u6700\u5c0f\u8981\u4ece 1 \u5f00\u59cb!");
        }
    }
}

