/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.data.convert.util;

import com.alibaba.excel.util.ObjectUtils;
import com.xforceplus.tower.data.convert.util.pdf.PdfReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PdfConvertUtil {
    private static Logger logger = LoggerFactory.getLogger(PdfConvertUtil.class);

    public static void generatePdf(File pdfTemplate, Map<String, String> data) {
        try {
            Objects.requireNonNull(pdfTemplate, "file pdfTemplate can not be null");
            Objects.requireNonNull(data, "replace data can not be null");
            PdfReplacer textReplacer = new PdfReplacer(pdfTemplate.getPath());
            Set<String> keys = data.keySet();
            for (String key : keys) {
                textReplacer.replaceText(key, String.valueOf(data.get(key)));
            }
            textReplacer.toPdf(pdfTemplate.getName());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void generatePdf(FileInputStream inputStream, Map<String, String> data, String pdfName) {
        try {
            String name = "default.pdf";
            Objects.requireNonNull(inputStream, "file inputStream can not be null");
            Objects.requireNonNull(data, "replace data can not be null");
            if (ObjectUtils.isEmpty((Object)pdfName)) {
                pdfName = "default.pdf";
            }
            PdfReplacer textReplacer = new PdfReplacer(inputStream);
            Set<String> keys = data.keySet();
            for (String key : keys) {
                textReplacer.replaceText(key, String.valueOf(data.get(key)));
            }
            textReplacer.toPdf(pdfName);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

