/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.data.convert.util.pdf;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.xforceplus.tower.data.convert.util.pdf.PositionRenderListener;
import com.xforceplus.tower.data.convert.util.pdf.ReplaceRegion;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PdfPositionParse {
    private PdfReader reader;
    private List<String> findText = new ArrayList<String>();
    private PdfReaderContentParser parser;
    private boolean needClose = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfPositionParse(String fileName) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(fileName);
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            this.init(bytes);
        }
    }

    public PdfPositionParse(byte[] bytes) throws IOException {
        this.init(bytes);
    }

    public PdfPositionParse(PdfReader reader) {
        this.reader = reader;
        this.parser = new PdfReaderContentParser(reader);
        this.needClose = false;
    }

    public void addFindText(String text) {
        this.findText.add(text);
    }

    private void init(byte[] bytes) throws IOException {
        this.reader = new PdfReader(bytes);
        this.parser = new PdfReaderContentParser(this.reader);
    }

    public Map<String, ReplaceRegion> parse() throws IOException {
        try {
            if (this.findText.size() == 0) {
                throw new NullPointerException("\u6ca1\u6709\u9700\u8981\u67e5\u627e\u7684\u6587\u672c");
            }
            PositionRenderListener listener = new PositionRenderListener(this.findText);
            this.parser.processContent(1, (RenderListener)listener);
            Map<String, ReplaceRegion> map = listener.getResult();
            return map;
        }
        finally {
            if (this.reader != null && this.needClose) {
                this.reader.close();
            }
        }
    }
}

