/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.data.convert.util.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.xforceplus.tower.data.convert.util.pdf.PdfPositionParse;
import com.xforceplus.tower.data.convert.util.pdf.ReplaceRegion;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfReplacer {
    private static final Logger logger = LoggerFactory.getLogger(PdfReplacer.class);
    private int fontSize;
    private Map<String, ReplaceRegion> replaceRegionMap = new HashMap<String, ReplaceRegion>();
    private Map<String, Object> replaceTextMap = new HashMap<String, Object>();
    private ByteArrayOutputStream output;
    private PdfReader reader;
    private PdfStamper stamper;
    private PdfContentByte canvas;
    private Font font;

    public PdfReplacer(byte[] pdfBytes) throws DocumentException, IOException {
        this.init(pdfBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfReplacer(String fileName) throws IOException, DocumentException {
        try (FileInputStream in = null;){
            in = new FileInputStream(fileName);
            byte[] pdfBytes = new byte[in.available()];
            in.read(pdfBytes);
            this.init(pdfBytes);
        }
    }

    public PdfReplacer(FileInputStream in) throws IOException, DocumentException {
        try {
            byte[] pdfBytes = new byte[in.available()];
            in.read(pdfBytes);
            this.init(pdfBytes);
        }
        finally {
            in.close();
        }
    }

    private void init(byte[] pdfBytes) throws DocumentException, IOException {
        logger.info("\u521d\u59cb\u5316\u5f00\u59cb");
        this.reader = new PdfReader(pdfBytes);
        this.output = new ByteArrayOutputStream();
        this.stamper = new PdfStamper(this.reader, (OutputStream)this.output);
        this.canvas = this.stamper.getOverContent(1);
        this.setFont(10);
        logger.info("\u521d\u59cb\u5316\u6210\u529f");
    }

    private void close() throws DocumentException, IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.output != null) {
            this.output.close();
        }
        this.output = null;
        this.replaceRegionMap = null;
        this.replaceTextMap = null;
    }

    public void replaceText(float x, float y, float w, float h, String text) {
        ReplaceRegion region = new ReplaceRegion(text);
        region.setH(Float.valueOf(h));
        region.setW(Float.valueOf(w));
        region.setX(Float.valueOf(x));
        region.setY(Float.valueOf(y));
        this.addReplaceRegion(region);
        this.replaceText(text, text);
    }

    public void replaceText(String name, String text) {
        this.replaceTextMap.put(name, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws DocumentException, IOException {
        try {
            ReplaceRegion value;
            this.parseReplaceText();
            this.canvas.saveState();
            Set<Map.Entry<String, ReplaceRegion>> entrys = this.replaceRegionMap.entrySet();
            for (Map.Entry<String, ReplaceRegion> entry : entrys) {
                value = entry.getValue();
                this.canvas.setColorFill(BaseColor.WHITE);
                this.canvas.rectangle(value.getX().floatValue(), value.getY().floatValue(), value.getW().floatValue(), value.getH().floatValue());
            }
            this.canvas.fill();
            this.canvas.restoreState();
            this.canvas.beginText();
            for (Map.Entry<String, ReplaceRegion> entry : entrys) {
                value = entry.getValue();
                this.canvas.setFontAndSize(this.font.getBaseFont(), (float)this.getFontSize());
                this.canvas.setTextMatrix(value.getX().floatValue(), value.getY().floatValue() + 2.0f);
                this.canvas.showText((String)this.replaceTextMap.get(value.getAliasName()));
            }
            this.canvas.endText();
        }
        finally {
            if (this.stamper != null) {
                this.stamper.close();
            }
        }
    }

    private void parseReplaceText() {
        PdfPositionParse parse = new PdfPositionParse(this.reader);
        Set<Map.Entry<String, Object>> entrys = this.replaceTextMap.entrySet();
        for (Map.Entry<String, Object> entry : entrys) {
            if (this.replaceRegionMap.get(entry.getKey()) != null) continue;
            parse.addFindText(entry.getKey());
        }
        try {
            Map<String, ReplaceRegion> parseResult = parse.parse();
            Set<Map.Entry<String, ReplaceRegion>> parseEntrys = parseResult.entrySet();
            for (Map.Entry<String, ReplaceRegion> entry : parseEntrys) {
                if (entry.getValue() == null) continue;
                this.replaceRegionMap.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void toPdf(String fileName) throws DocumentException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            this.process();
            fileOutputStream = new FileOutputStream(fileName);
            fileOutputStream.write(this.output.toByteArray());
            fileOutputStream.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            this.close();
        }
        logger.info("\u6587\u4ef6\u751f\u6210\u6210\u529f");
    }

    public byte[] toBytes() throws DocumentException, IOException {
        try {
            this.process();
            logger.info("\u4e8c\u8fdb\u5236\u6570\u636e\u751f\u6210\u6210\u529f");
            byte[] byArray = this.output.toByteArray();
            return byArray;
        }
        finally {
            this.close();
        }
    }

    public void addReplaceRegion(ReplaceRegion replaceRegion) {
        this.replaceRegionMap.put(replaceRegion.getAliasName(), replaceRegion);
    }

    public ReplaceRegion getReplaceRegion(String aliasName) {
        return this.replaceRegionMap.get(aliasName);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFont(int fontSize) throws DocumentException, IOException {
        if (fontSize != this.fontSize) {
            this.fontSize = fontSize;
            BaseFont bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
            this.font = new Font(bf, (float)this.fontSize, 1);
        }
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font is null");
        }
        this.font = font;
    }
}

